/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.granite.client.persistence.collection.AbstractPersistentCollection;

public abstract class AbstractPersistentMapCollection<K, V, C extends Map<K, V>>
extends AbstractPersistentCollection<C>
implements Map<K, V> {
    @Override
    public int size() {
        if (!this.checkInitializedRead()) {
            return 0;
        }
        return ((Map)this.getCollection()).size();
    }

    @Override
    public boolean isEmpty() {
        if (!this.checkInitializedRead()) {
            return true;
        }
        return ((Map)this.getCollection()).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.checkInitializedRead()) {
            return false;
        }
        return ((Map)this.getCollection()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.checkInitializedRead()) {
            return false;
        }
        return ((Map)this.getCollection()).containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((Map)this.getCollection()).get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, true);
    }

    protected V put(K key, V value, boolean checkInitialized) {
        if (checkInitialized) {
            this.checkInitializedWrite();
        }
        boolean containsKey = ((Map)this.getCollection()).containsKey(key);
        V previousValue = ((Map)this.getCollection()).put(key, value);
        if (!containsKey || (previousValue == null ? value != null : !previousValue.equals(value))) {
            this.dirty();
        }
        return previousValue;
    }

    @Override
    public V remove(Object key) {
        this.checkInitializedWrite();
        boolean containsKey = ((Map)this.getCollection()).containsKey(key);
        Object removedValue = ((Map)this.getCollection()).remove(key);
        if (containsKey) {
            this.dirty();
        }
        return removedValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkInitializedWrite();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), false);
        }
    }

    @Override
    public void clear() {
        this.checkInitializedWrite();
        if (!((Map)this.getCollection()).isEmpty()) {
            ((Map)this.getCollection()).clear();
            this.dirty();
        }
    }

    @Override
    public Set<K> keySet() {
        if (!this.checkInitializedRead()) {
            return Collections.emptySet();
        }
        return (AbstractPersistentCollection)this.new AbstractPersistentCollection.SetProxy(((Map)this.getCollection()).keySet());
    }

    @Override
    public Collection<V> values() {
        if (!this.checkInitializedRead()) {
            return Collections.emptySet();
        }
        return new AbstractPersistentCollection.CollectionProxy(((Map)this.getCollection()).values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (!this.checkInitializedRead()) {
            return Collections.emptySet();
        }
        return (AbstractPersistentCollection)this.new AbstractPersistentCollection.SetProxy(((Map)this.getCollection()).entrySet());
    }
}

