/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.util.Collection;
import java.util.Map;
import org.granite.client.messaging.amf.persistence.AMFPersistentCollectionSnapshotFactory;
import org.granite.client.messaging.jmf.persistence.JMFPersistentCollectionSnapshotFactory;
import org.granite.messaging.jmf.ExtendedObjectInput;
import org.granite.messaging.jmf.ExtendedObjectOutput;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;
import org.granite.util.ContentType;

public abstract class PersistentCollectionSnapshotFactory {
    public static PersistentCollectionSnapshotFactory newInstance(Object io) {
        if (io instanceof ExtendedObjectInput || io instanceof ExtendedObjectOutput) {
            return PersistentCollectionSnapshotFactory.newInstance(ContentType.JMF_AMF);
        }
        return PersistentCollectionSnapshotFactory.newInstance(ContentType.AMF);
    }

    public static PersistentCollectionSnapshotFactory newInstance(ContentType contentType) {
        switch (contentType) {
            case JMF_AMF: {
                return new JMFPersistentCollectionSnapshotFactory();
            }
            case AMF: {
                return new AMFPersistentCollectionSnapshotFactory();
            }
        }
        throw new UnsupportedOperationException("Unsupported content type: " + (Object)((Object)contentType));
    }

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(String var1);

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(boolean var1, String var2);

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(boolean var1, String var2, boolean var3, Collection<?> var4);

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(boolean var1, String var2, boolean var3, Map<?, ?> var4);
}

