/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.io.ObjectInput;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.granite.client.persistence.collection.AbstractPersistentMapCollection;
import org.granite.client.persistence.collection.PersistentCollectionSnapshotFactory;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public class PersistentMap<K, V>
extends AbstractPersistentMapCollection<K, V, Map<K, V>>
implements Map<K, V> {
    public PersistentMap() {
    }

    public PersistentMap(boolean initialized) {
        this(initialized ? new HashMap() : null, false);
    }

    public PersistentMap(Map<K, V> collection) {
        this(collection, true);
    }

    public PersistentMap(Map<K, V> collection, boolean clone) {
        if (collection instanceof SortedMap) {
            throw new IllegalArgumentException("Should not be a SortedMap: " + collection);
        }
        if (collection != null) {
            this.init(clone ? new HashMap(collection) : collection, null, false);
        }
    }

    @Override
    public void doInitialize() {
        this.init(new HashMap(), null, false);
    }

    @Override
    protected PersistentCollectionSnapshot createSnapshot(Object io, boolean forReading) {
        PersistentCollectionSnapshotFactory factory = PersistentCollectionSnapshotFactory.newInstance(io);
        if (forReading || !this.wasInitialized()) {
            return factory.newPersistentCollectionSnapshot(this.getDetachedState());
        }
        return factory.newPersistentCollectionSnapshot(true, this.getDetachedState(), this.isDirty(), this);
    }

    @Override
    protected void updateFromSnapshot(ObjectInput in, PersistentCollectionSnapshot snapshot) {
        if (snapshot.isInitialized()) {
            this.init(new HashMap(snapshot.getElementsAsMap()), snapshot.getDetachedState(), snapshot.isDirty());
        } else {
            this.init(null, snapshot.getDetachedState(), false);
        }
    }

    @Override
    public PersistentMap<K, V> clone(boolean uninitialize) {
        PersistentMap<K, V> map = new PersistentMap<K, V>();
        if (this.wasInitialized() && !uninitialize) {
            map.init(this.getCollection(), null, this.isDirty());
        }
        return map;
    }
}

