/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.platform;

import java.util.Iterator;
import org.granite.client.configuration.Configuration;
import org.granite.client.configuration.SimpleConfiguration;
import org.granite.client.messaging.ExtCosRemoteAliasScanner;
import org.granite.client.messaging.RemoteAliasScanner;
import org.granite.client.messaging.StandardRemoteAliasScanner;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.apache.ApacheAsyncTransport;
import org.granite.client.persistence.Persistence;
import org.granite.client.platform.PlatformConfigurationError;
import org.granite.logging.Logger;
import org.granite.messaging.reflect.Reflection;
import org.granite.scan.ServiceLoader;

public class Platform {
    private static final Logger log = Logger.getLogger(Platform.class);
    public static final String SYSTEM_PROPERTY_KEY = Platform.class.getName();
    protected static Platform instance = null;
    protected final Reflection reflection;
    protected final Persistence persistence;
    protected Object context;

    public static synchronized Platform getInstance() {
        if (instance == null) {
            String platformClassName = System.getProperty(SYSTEM_PROPERTY_KEY);
            if (platformClassName == null) {
                Platform.initInstance((ClassLoader)null);
            }
            if (instance == null) {
                Platform.initInstance(platformClassName, null);
            }
        }
        return instance;
    }

    public static synchronized Platform initInstance(ClassLoader platformClassLoader) {
        if (instance != null) {
            throw new IllegalStateException("Platform already loaded");
        }
        if (platformClassLoader == null) {
            platformClassLoader = Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<Platform> platformLoader = ServiceLoader.load(Platform.class, platformClassLoader);
        Iterator platforms = null;
        try {
            platforms = platformLoader.iterator();
            if (platforms.hasNext()) {
                instance = (Platform)platforms.next();
            }
            if (platforms.hasNext()) {
                throw new PlatformConfigurationError("Multiple Platform services: " + instance + " / " + platforms.next());
            }
        }
        catch (PlatformConfigurationError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PlatformConfigurationError("Could not load Platform service", t);
        }
        return instance;
    }

    public static synchronized Platform initInstance(String platformClassName) {
        return Platform.initInstance(platformClassName, null);
    }

    public static synchronized Platform initInstance(String platformClassName, ClassLoader platformClassLoader) {
        return Platform.initInstance(platformClassName, platformClassLoader, null);
    }

    public static synchronized Platform initInstance(String platformClassName, ClassLoader platformClassLoader, ClassLoader reflectionClassLoader) {
        if (instance != null) {
            throw new IllegalStateException("Platform already loaded");
        }
        if (platformClassLoader == null) {
            platformClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (platformClassName == null) {
            platformClassName = Platform.class.getName();
        }
        try {
            Class<?> platformClass = platformClassLoader.loadClass(platformClassName);
            instance = (Platform)platformClass.getConstructor(ClassLoader.class).newInstance(reflectionClassLoader);
        }
        catch (Throwable t) {
            throw new PlatformConfigurationError("Could not create new Platform of type: " + platformClassName, t);
        }
        return instance;
    }

    public Platform() {
        this(new Reflection(null));
    }

    public Platform(ClassLoader reflectionClassLoader) {
        this(new Reflection(reflectionClassLoader));
    }

    public Platform(Reflection reflection) {
        if (reflection == null) {
            throw new NullPointerException("reflection cannot be null");
        }
        this.reflection = reflection;
        this.persistence = new Persistence(reflection);
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public RemoteAliasScanner newRemoteAliasScanner() {
        try {
            return new ExtCosRemoteAliasScanner();
        }
        catch (Throwable t) {
            log.debug(t, "Extcos scanner not available, using classpath scanner", new Object[0]);
            return new StandardRemoteAliasScanner();
        }
    }

    public Reflection getReflection() {
        return this.reflection;
    }

    public Configuration newConfiguration() {
        return new SimpleConfiguration();
    }

    public Transport newRemotingTransport() {
        return new ApacheAsyncTransport();
    }

    public Transport newMessagingTransport() {
        return null;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public static Reflection reflection() {
        return Platform.getInstance().reflection;
    }

    public static Persistence persistence() {
        return Platform.getInstance().persistence;
    }
}

