/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private Map<IdentityWeakReference, V> map;

    public WeakIdentityHashMap() {
        this.map = new HashMap<IdentityWeakReference, V>();
    }

    public WeakIdentityHashMap(int size) {
        this.map = new HashMap<IdentityWeakReference, V>(size);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.reap();
    }

    @Override
    public boolean containsKey(Object key) {
        this.reap();
        return this.map.containsKey(new IdentityWeakReference(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.reap();
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.reap();
        HashSet<1> ret = new HashSet<1>();
        for (Map.Entry<IdentityWeakReference, V> ref : this.map.entrySet()) {
            final Object key = ref.getKey().get();
            final V value = ref.getValue();
            Map.Entry entry = new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            };
            ret.add(entry);
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<K> keySet() {
        this.reap();
        HashSet ret = new HashSet();
        for (IdentityWeakReference ref : this.map.keySet()) {
            ret.add(ref.get());
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(((WeakIdentityHashMap)o).map);
    }

    @Override
    public V get(Object key) {
        this.reap();
        return this.map.get(new IdentityWeakReference(key));
    }

    @Override
    public V put(K key, V value) {
        this.reap();
        return this.map.put(new IdentityWeakReference(key), value);
    }

    @Override
    public int hashCode() {
        this.reap();
        return ((Object)this.map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.reap();
        return this.map.isEmpty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        this.reap();
        return this.map.remove(new IdentityWeakReference(key));
    }

    @Override
    public int size() {
        this.reap();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        this.reap();
        return this.map.values();
    }

    private synchronized void reap() {
        Reference<K> zombie = this.queue.poll();
        while (zombie != null) {
            IdentityWeakReference victim = (IdentityWeakReference)zombie;
            this.map.remove(victim);
            zombie = this.queue.poll();
        }
    }

    class IdentityWeakReference
    extends WeakReference<K> {
        private final int hash;

        IdentityWeakReference(Object obj) {
            super(obj, WeakIdentityHashMap.this.queue);
            this.hash = System.identityHashCode(obj);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            IdentityWeakReference ref = (IdentityWeakReference)o;
            return this.get() == ref.get();
        }
    }
}

