/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.granite.messaging.amf.io.AMF3DeserializerSecurizer;

public class RegexAMF3DeserializerSecurizer
implements AMF3DeserializerSecurizer {
    private Pattern allow = null;
    private ConcurrentMap<String, Boolean> cache = new ConcurrentHashMap<String, Boolean>();

    public boolean allowInstantiation(String className) {
        if (this.allow == null || className == null || className.length() == 0) {
            return true;
        }
        if (this.cache.containsKey(className)) {
            return true;
        }
        boolean allowed = this.allow.matcher(className).matches();
        if (allowed) {
            this.cache.putIfAbsent(className, Boolean.TRUE);
        }
        return allowed;
    }

    public void setParam(String param) {
        if (param == null || param.length() == 0) {
            this.allow = null;
        } else {
            StringBuilder sb = new StringBuilder(param.length());
            for (String s : param.split("\\s", -1)) {
                if (s.length() <= 0) continue;
                sb.append(s);
            }
            this.allow = Pattern.compile(sb.toString());
        }
        this.cache = new ConcurrentHashMap<String, Boolean>();
    }

    public String getParam() {
        return this.allow != null ? this.allow.pattern() : null;
    }
}

