/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Map;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.util.MapUtil;
import org.granite.util.TypeUtil;

public class Map2Map
extends Converter {
    public Map2Map(Converters converters) {
        super(converters);
    }

    protected boolean internalCanConvert(Object value, Type targetType) {
        Type[] targetComponentTypes = MapUtil.getComponentTypes(targetType);
        if (targetComponentTypes == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!(value instanceof Map)) {
            return false;
        }
        Type keyType = targetComponentTypes[0];
        Type valueType = targetComponentTypes[1];
        if ((keyType.equals(Object.class) || keyType instanceof WildcardType) && (valueType.equals(Object.class) || valueType instanceof WildcardType)) {
            return true;
        }
        Converter keyConverter = null;
        Converter valueConverter = null;
        for (Map.Entry item : ((Map)value).entrySet()) {
            if (keyConverter == null) {
                keyConverter = this.converters.getConverter(item.getKey(), keyType);
            } else if (!keyConverter.canConvert(item.getKey(), keyType)) {
                keyConverter = this.converters.getConverter(item.getKey(), keyType);
            }
            if (keyConverter == null) {
                return false;
            }
            if (valueConverter == null) {
                valueConverter = this.converters.getConverter(item.getValue(), valueType);
            } else if (!valueConverter.canConvert(item.getValue(), valueType)) {
                valueConverter = this.converters.getConverter(item.getValue(), valueType);
            }
            if (valueConverter != null) continue;
            return false;
        }
        return true;
    }

    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            Type[] targetComponentTypes = MapUtil.getComponentTypes(targetType);
            if (targetComponentTypes != null) {
                Type keyType = targetComponentTypes[0];
                Type valueType = targetComponentTypes[1];
                Class<?> targetClass = TypeUtil.classOfType(targetType);
                if (targetClass.isInstance(value) && (keyType.equals(Object.class) || keyType instanceof WildcardType) && (valueType.equals(Object.class) || valueType instanceof WildcardType)) {
                    return value;
                }
                if (targetClass.isInstance(value)) {
                    Class<?> keyClass = TypeUtil.classOfType(keyType);
                    Class<?> valueClass = TypeUtil.classOfType(valueType);
                    boolean compatible = true;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        if (keyClass.isInstance(entry.getKey()) && valueClass.isInstance(entry.getValue())) continue;
                        compatible = false;
                        break;
                    }
                    if (compatible) {
                        return value;
                    }
                }
                Map<Object, Object> targetInstance = null;
                try {
                    targetInstance = MapUtil.newMap(targetClass, map.size());
                }
                catch (Exception e) {
                    throw new IllegalConverterArgumentException((Converter)this, value, targetType, e);
                }
                Converter keyConverter = null;
                Converter valueConverter = null;
                for (Map.Entry item : ((Map)value).entrySet()) {
                    if (keyConverter == null) {
                        keyConverter = this.converters.getConverter(item.getKey(), keyType);
                    } else if (!keyConverter.canConvert(item.getKey(), keyType)) {
                        keyConverter = this.converters.getConverter(item.getKey(), keyType);
                    }
                    if (keyConverter == null) {
                        throw new IllegalConverterArgumentException(this, value, targetType);
                    }
                    if (valueConverter == null) {
                        valueConverter = this.converters.getConverter(item.getValue(), valueType);
                    } else if (!valueConverter.canConvert(item.getValue(), valueType)) {
                        valueConverter = this.converters.getConverter(item.getValue(), valueType);
                    }
                    if (valueConverter == null) {
                        throw new IllegalConverterArgumentException(this, value, targetType);
                    }
                    targetInstance.put(keyConverter.convert(item.getKey(), keyType), valueConverter.convert(item.getValue(), valueType));
                }
                return targetInstance;
            }
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

