/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.util.TypeUtil;

public class String2Enum
extends Converter {
    public String2Enum(Converters converters) {
        super(converters);
    }

    protected boolean internalCanConvert(Object value, Type targetType) {
        return Enum.class.isAssignableFrom(TypeUtil.classOfType(targetType)) && (value == null || value instanceof String || value instanceof Enum);
    }

    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        Class<?> enumType = TypeUtil.classOfType(targetType);
        String enumValue = value instanceof String ? (String)value : ((Enum)value).name();
        try {
            Method m = enumType.getClass().getMethod("valueOf", enumType, String.class);
            return m.invoke(enumType, enumValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Cound not convert " + value + " to enum of type " + targetType, e);
        }
    }

    public boolean canRevert(Object value) {
        return value == null || value instanceof Locale;
    }

    public Object revert(Object value) {
        if (value != null) {
            value = value.toString();
        }
        return value;
    }
}

