/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.io.Externalizable;
import java.util.List;
import java.util.Map;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaClassDescriptor {
    protected final Class<?> type;
    protected final String name;
    protected final Externalizer externalizer;
    protected final Converters converters;
    protected final byte encoding;
    protected final List<Property> properties;

    protected JavaClassDescriptor(Class<?> type) {
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        this.type = type;
        this.name = JavaClassDescriptor.getClassName(type);
        this.externalizer = config.getExternalizer(type.getName());
        this.converters = config.getConverters();
        this.encoding = this.findEncoding(type);
        this.properties = this.introspectProperties();
    }

    private byte findEncoding(Class<?> type) {
        if (this.externalizer != null || Externalizable.class.isAssignableFrom(type)) {
            return 1;
        }
        if (Map.class.isAssignableFrom(type)) {
            return 2;
        }
        return 0;
    }

    protected abstract List<Property> introspectProperties();

    public static String getClassName(Class<?> clazz) {
        Externalizer externalizer;
        if (Map.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && (externalizer = GraniteContext.getCurrentInstance().getGraniteConfig().getExternalizer(clazz.getName())) == null) {
            return "";
        }
        return GraniteContext.getCurrentInstance().getGraniteConfig().getAliasRegistry().getAliasForType(clazz.getName());
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public boolean isExternalizable() {
        return this.encoding == 1;
    }

    public boolean isDynamic() {
        return this.encoding == 2;
    }

    public int getPropertiesCount() {
        return this.properties != null ? this.properties.size() : 0;
    }

    public String getPropertyName(int index) {
        if (this.properties == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.properties.get(index).getName();
    }

    public Object getPropertyValue(int index, Object instance) {
        if (this.properties == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Property prop = this.properties.get(index);
        return prop.getProperty(instance);
    }
}

