/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.DoubleCodec;
import org.granite.messaging.jmf.codec.std.LongCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleCodecImpl
extends AbstractStandardCodec<Double>
implements DoubleCodec {
    @Override
    public int getObjectType() {
        return 29;
    }

    @Override
    public Class<?> getObjectClass() {
        return Double.class;
    }

    @Override
    public int getPrimitiveType() {
        return 28;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Double.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Double v) throws IOException {
        DoubleCodecImpl.writeDoubleData(ctx, 29, v);
    }

    @Override
    public Double decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 29) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, double v) throws IOException {
        DoubleCodecImpl.writeDoubleData(ctx, 28, v);
    }

    @Override
    public double decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 28) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 28: {
                ctx.indentPrintLn("double: " + DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType));
                break;
            }
            case 29: {
                ctx.indentPrintLn(Double.class.getName() + ": " + Double.valueOf(DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    public static void writeDoubleData(OutputContext ctx, int jmfType, double v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (Double.isNaN(v)) {
            os.write(0xC0 | jmfType);
        } else {
            long asLong = (long)v;
            LongCodec longCodec = ctx.getSharedContext().getCodecRegistry().getLongCodec();
            int lengthAsLong = Integer.MAX_VALUE;
            if (v == (double)asLong) {
                if (v == -9.223372036854776E18) {
                    lengthAsLong = 1;
                } else if (Double.doubleToRawLongBits(v) != Long.MIN_VALUE) {
                    lengthAsLong = longCodec.lengthOfVariableAbsoluteLong(Math.abs(asLong)) + 1;
                }
            }
            if (lengthAsLong < 4) {
                os.write(0x80 | jmfType);
                longCodec.writeVariableLong(ctx, asLong);
            } else if (v == (double)((float)v)) {
                os.write(0x40 | jmfType);
                int bits = Float.floatToIntBits((float)v);
                os.write(bits);
                os.write(bits >> 8);
                os.write(bits >> 16);
                os.write(bits >> 24);
            } else if (lengthAsLong < 8) {
                os.write(0x80 | jmfType);
                longCodec.writeVariableLong(ctx, asLong);
            } else {
                os.write(jmfType);
                long bits = Double.doubleToLongBits(v);
                os.write((int)bits);
                os.write((int)(bits >> 8));
                os.write((int)(bits >> 16));
                os.write((int)(bits >> 24));
                os.write((int)(bits >> 32));
                os.write((int)(bits >> 40));
                os.write((int)(bits >> 48));
                os.write((int)(bits >> 56));
            }
        }
    }

    public static double readDoubleData(InputContext ctx, int type) throws IOException {
        double v;
        switch (type >> 6 & 3) {
            case 3: {
                v = Double.NaN;
                break;
            }
            case 2: {
                v = ctx.getSharedContext().getCodecRegistry().getLongCodec().readVariableLong(ctx);
                break;
            }
            case 1: {
                int i = ctx.safeRead();
                i |= ctx.safeRead() << 8;
                i |= ctx.safeRead() << 16;
                v = Float.intBitsToFloat(i |= ctx.safeRead() << 24);
                break;
            }
            default: {
                long l = ctx.safeRead();
                l |= (long)ctx.safeRead() << 8;
                l |= (long)ctx.safeRead() << 16;
                l |= (long)ctx.safeRead() << 24;
                l |= (long)ctx.safeRead() << 32;
                l |= (long)ctx.safeRead() << 40;
                l |= (long)ctx.safeRead() << 48;
                v = Double.longBitsToDouble(l |= (long)ctx.safeRead() << 56);
            }
        }
        return v;
    }
}

