/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.HashMapCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapCodecImpl
extends AbstractIntegerStringCodec<HashMap<?, ?>>
implements HashMapCodec {
    @Override
    public int getObjectType() {
        return 13;
    }

    @Override
    public Class<?> getObjectClass() {
        return HashMap.class;
    }

    @Override
    public void encode(OutputContext ctx, HashMap<?, ?> v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredObject = ctx.indexOfStoredObjects(v);
        if (indexOfStoredObject >= 0) {
            AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(indexOfStoredObject);
            os.write(0x80 | ics.length << 5 | 0xD);
            this.writeIntData(ctx, ics);
        } else {
            ctx.addToStoredObjects(v);
            Map.Entry[] snapshot = v.entrySet().toArray(new Map.Entry[0]);
            AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(snapshot.length);
            os.write(ics.length << 5 | 0xD);
            this.writeIntData(ctx, ics);
            for (Map.Entry entry : snapshot) {
                ctx.writeObject(entry.getKey());
                ctx.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public HashMap<?, ?> decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 13) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 5 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            return (HashMap)ctx.getSharedObject(indexOrLength);
        }
        HashMap<Object, Object> v = new HashMap<Object, Object>(indexOrLength);
        ctx.addSharedObject(v);
        for (int index = 0; index < indexOrLength; ++index) {
            Object key = ctx.readObject();
            Object value = ctx.readObject();
            v.put(key, value);
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 13) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 5 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            String v = (String)ctx.getSharedObject(indexOrLength);
            ctx.indentPrintLn("<" + v + "@" + indexOrLength + ">");
            return;
        }
        String v = HashMap.class.getName() + "[" + indexOrLength + "]";
        int indexOfStoredObject = ctx.addSharedObject(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + " {");
        ctx.incrIndent(1);
        for (int index = 0; index < indexOrLength; ++index) {
            parameterizedJmfType = ctx.safeRead();
            jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            StandardCodec codec = codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
            ctx.incrIndent(1);
            parameterizedJmfType = ctx.safeRead();
            jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            codec = codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
            ctx.incrIndent(-1);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }
}

