/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.IntegerCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerCodecImpl
extends AbstractIntegerStringCodec<Integer>
implements IntegerCodec {
    protected static final int[] VARIABLE_INT_DELTAS = new int[5];

    @Override
    public int getObjectType() {
        return 9;
    }

    @Override
    public Class<?> getObjectClass() {
        return Integer.class;
    }

    @Override
    public int getPrimitiveType() {
        return 8;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Integer.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Integer v) throws IOException {
        this.writeIntData(ctx, 9, v);
    }

    @Override
    public Integer decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 9) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readIntData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, int v) throws IOException {
        this.writeIntData(ctx, 8, v);
    }

    @Override
    public int decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 8) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readIntData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 8: {
                ctx.indentPrintLn("int: " + this.readIntData(ctx, parameterizedJmfType));
                break;
            }
            case 9: {
                ctx.indentPrintLn(Integer.class.getName() + ": " + Integer.valueOf(this.readIntData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    protected void writeIntData(OutputContext ctx, int jmfType, int v) throws IOException {
        AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(v);
        ctx.getOutputStream().write(ics.sign << 7 | ics.length << 5 | jmfType);
        this.writeIntData(ctx, ics);
    }

    protected int readIntData(InputContext ctx, int parameterizedJmfType) throws IOException {
        return this.readIntData(ctx, parameterizedJmfType >> 5 & 3, (parameterizedJmfType & 0x80) != 0);
    }

    @Override
    public void writeVariableInt(OutputContext ctx, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v == Integer.MIN_VALUE) {
            os.write(128);
        } else {
            int sign = 0;
            if (v < 0) {
                sign = 128;
                v = -v;
            }
            int bytesCount = IntegerCodecImpl.lengthOfVariableAbsoluteInt(v);
            v -= IntegerCodecImpl.deltaForVariableAbsoluteIntLength(bytesCount);
            switch (bytesCount) {
                case 0: {
                    os.write(sign | v);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    os.write(sign | 0x40 | v >> bytesCount * 7);
                    for (int i = bytesCount - 1; i > 0; --i) {
                        os.write(0x80 | v >> i * 7);
                    }
                    os.write(0x7F & v);
                    break;
                }
                case 4: {
                    os.write(sign | 0x40 | v >> 29);
                    os.write(0x80 | v >> 22);
                    os.write(0x80 | v >> 15);
                    os.write(0x80 | v >> 8);
                    os.write(v);
                }
            }
        }
    }

    @Override
    public int readVariableInt(InputContext ctx) throws IOException {
        int v = ctx.safeRead();
        if (v == 128) {
            v = Integer.MIN_VALUE;
        } else {
            boolean opposite = (v & 0x80) != 0;
            boolean readNext = (v & 0x40) != 0;
            v &= 0x3F;
            if (readNext) {
                int l = 1;
                for (int i = 1; i <= 3; ++i) {
                    int u = ctx.safeRead();
                    v = v << 7 | u & 0x7F;
                    if ((u & 0x80) == 0) {
                        readNext = false;
                        break;
                    }
                    ++l;
                }
                if (readNext) {
                    v = v << 8 | ctx.safeRead();
                }
                v += IntegerCodecImpl.deltaForVariableAbsoluteIntLength(l);
            }
            if (opposite) {
                v = -v;
            }
        }
        return v;
    }

    protected static int lengthOfVariableAbsoluteInt(int abs) {
        for (int i = 1; i < VARIABLE_INT_DELTAS.length; ++i) {
            if (abs >= VARIABLE_INT_DELTAS[i]) continue;
            return i - 1;
        }
        return 4;
    }

    protected static int deltaForVariableAbsoluteIntLength(int len) {
        return VARIABLE_INT_DELTAS[len];
    }

    static {
        IntegerCodecImpl.VARIABLE_INT_DELTAS[0] = 0;
        for (int i = 1; i < VARIABLE_INT_DELTAS.length; ++i) {
            IntegerCodecImpl.VARIABLE_INT_DELTAS[i] = VARIABLE_INT_DELTAS[i - 1] << 7 | 0x40;
        }
    }
}

