/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.LongCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongCodecImpl
extends AbstractStandardCodec<Long>
implements LongCodec {
    protected static final long[] VARIABLE_LONG_DELTAS = new long[9];

    @Override
    public int getObjectType() {
        return 5;
    }

    @Override
    public Class<?> getObjectClass() {
        return Long.class;
    }

    @Override
    public int getPrimitiveType() {
        return 4;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Long.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Long v) throws IOException {
        this.writeLongData(ctx, 5, v);
    }

    @Override
    public Long decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 5) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readLongData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, long v) throws IOException {
        this.writeLongData(ctx, 4, v);
    }

    @Override
    public long decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 4) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readLongData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 4: {
                ctx.indentPrintLn("long: " + this.readLongData(ctx, parameterizedJmfType));
                break;
            }
            case 5: {
                ctx.indentPrintLn(Long.class.getName() + ": " + Long.valueOf(this.readLongData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    protected void writeLongData(OutputContext ctx, int jmfType, long v) throws IOException {
        int l = 7;
        int s = 0;
        if (v != Long.MIN_VALUE) {
            if (v < 0L) {
                s = 128;
                v = -v;
            }
            l = this.lenghtOfAbsoluteLong(v);
        }
        OutputStream os = ctx.getOutputStream();
        os.write(s | l << 4 | jmfType);
        switch (l) {
            case 7: {
                os.write((int)(v >> 56));
            }
            case 6: {
                os.write((int)(v >> 48));
            }
            case 5: {
                os.write((int)(v >> 40));
            }
            case 4: {
                os.write((int)(v >> 32));
            }
            case 3: {
                os.write((int)(v >> 24));
            }
            case 2: {
                os.write((int)(v >> 16));
            }
            case 1: {
                os.write((int)(v >> 8));
            }
            case 0: {
                os.write((int)v);
            }
        }
    }

    protected int lenghtOfAbsoluteLong(long v) {
        if (v <= 0xFFFFFFFFL) {
            if (v <= 65535L) {
                return v <= 255L ? 0 : 1;
            }
            return v <= 0xFFFFFFL ? 2 : 3;
        }
        if (v <= 0xFFFFFFFFFFFFL) {
            return v <= 0xFFFFFFFFFFL ? 4 : 5;
        }
        return v <= 0xFFFFFFFFFFFFFFL ? 6 : 7;
    }

    protected long readLongData(InputContext ctx, int parameterizedJmfType) throws IOException {
        long v = 0L;
        switch (parameterizedJmfType >> 4 & 7) {
            case 7: {
                v |= (long)ctx.safeRead() << 56;
            }
            case 6: {
                v |= (long)ctx.safeRead() << 48;
            }
            case 5: {
                v |= (long)ctx.safeRead() << 40;
            }
            case 4: {
                v |= (long)ctx.safeRead() << 32;
            }
            case 3: {
                v |= (long)ctx.safeRead() << 24;
            }
            case 2: {
                v |= (long)ctx.safeRead() << 16;
            }
            case 1: {
                v |= (long)ctx.safeRead() << 8;
            }
            case 0: {
                v |= (long)ctx.safeRead();
            }
        }
        if ((parameterizedJmfType & 0x80) != 0) {
            v = -v;
        }
        return v;
    }

    @Override
    public void writeVariableLong(OutputContext ctx, long v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v == Long.MIN_VALUE) {
            os.write(128);
        } else {
            int sign = 0;
            if (v < 0L) {
                sign = 128;
                v = -v;
            }
            int bytesCount = this.lengthOfVariableAbsoluteLong(v);
            v -= LongCodecImpl.deltaForVariableAbsoluteLongLength(bytesCount);
            switch (bytesCount) {
                case 0: {
                    os.write(sign | (int)v);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    os.write(sign | 0x40 | (int)(v >> bytesCount * 7));
                    for (int i = bytesCount - 1; i > 0; --i) {
                        os.write(0x80 | (int)(v >> i * 7));
                    }
                    os.write(0x7F & (int)v);
                    break;
                }
                case 8: {
                    os.write(sign | 0x40 | (int)(v >> 57));
                    os.write(0x80 | (int)(v >> 50));
                    os.write(0x80 | (int)(v >> 43));
                    os.write(0x80 | (int)(v >> 36));
                    os.write(0x80 | (int)(v >> 29));
                    os.write(0x80 | (int)(v >> 22));
                    os.write(0x80 | (int)(v >> 15));
                    os.write(0x80 | (int)(v >> 8));
                    os.write((int)v);
                }
            }
        }
    }

    @Override
    public long readVariableLong(InputContext ctx) throws IOException {
        long v = ctx.safeRead();
        if (v == 128L) {
            v = Long.MIN_VALUE;
        } else {
            boolean opposite = (v & 0x80L) != 0L;
            boolean readNext = (v & 0x40L) != 0L;
            v &= 0x3FL;
            if (readNext) {
                int l = 1;
                for (int i = 1; i <= 7; ++i) {
                    long u = ctx.safeRead();
                    v = v << 7 | u & 0x7FL;
                    if ((u & 0x80L) == 0L) {
                        readNext = false;
                        break;
                    }
                    ++l;
                }
                if (readNext) {
                    v = v << 8 | (long)ctx.safeRead();
                }
                v += LongCodecImpl.deltaForVariableAbsoluteLongLength(l);
            }
            if (opposite) {
                v = -v;
            }
        }
        return v;
    }

    @Override
    public int lengthOfVariableAbsoluteLong(long abs) {
        for (int i = 1; i < VARIABLE_LONG_DELTAS.length; ++i) {
            if (abs >= VARIABLE_LONG_DELTAS[i]) continue;
            return i - 1;
        }
        return 8;
    }

    protected static long deltaForVariableAbsoluteLongLength(int len) {
        return VARIABLE_LONG_DELTAS[len];
    }

    static {
        LongCodecImpl.VARIABLE_LONG_DELTAS[0] = 0L;
        for (int i = 1; i < VARIABLE_LONG_DELTAS.length; ++i) {
            LongCodecImpl.VARIABLE_LONG_DELTAS[i] = VARIABLE_LONG_DELTAS[i - 1] << 7 | 0x40L;
        }
    }
}

