/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.tide;

import java.util.Set;
import org.granite.config.GraniteConfigException;
import org.granite.messaging.service.tide.TideComponentMatcher;
import org.granite.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideComponentInstanceOfMatcher
implements TideComponentMatcher {
    private final boolean disabled;
    private final Class<?> parentClass;

    public TideComponentInstanceOfMatcher(String type, boolean disabled) {
        try {
            this.parentClass = TypeUtil.forName(type);
            this.disabled = disabled;
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate instanceof matcher parent class: " + type, e);
        }
    }

    @Override
    public boolean matches(String name, Set<Class<?>> classes, Object instance, boolean disabled) {
        for (Class<?> clazz : classes) {
            if (disabled != this.disabled || !this.parentClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Instanceof matcher: " + this.parentClass.getName() + (this.disabled ? " (disabled)" : "");
    }
}

