/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemClassLoader;
import org.granite.scan.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScannedItem
implements ScannedItem {
    private final Scanner scanner;
    private final ScannedItem marker;
    private Class<?> clazz = null;
    private Properties properties = null;

    public AbstractScannedItem(Scanner scanner, ScannedItem marker) {
        this.scanner = scanner;
        this.marker = marker;
    }

    @Override
    public ScannedItem getMarker() {
        return this.marker;
    }

    @Override
    public Scanner getScanner() {
        return this.scanner;
    }

    @Override
    public String getExtension() {
        String name = this.getName();
        int lastDot = name.indexOf(46);
        return lastDot >= 0 ? name.substring(lastDot + 1) : null;
    }

    @Override
    public String getClassName() {
        if (!"class".equals(this.getExtension())) {
            throw new RuntimeException("Not a valid class name: " + this.getAbsolutePath());
        }
        return this.getRelativePath().substring(0, this.getRelativePath().length() - 6).replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContent() throws IOException {
        long size = this.getSize();
        if (size > Integer.MAX_VALUE) {
            throw new IOException("Size over Integer.MAX_VALUE: " + size);
        }
        InputStream is = null;
        try {
            is = this.getInputStream();
            byte[] data = new byte[(int)size];
            is.read(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public Class<?> loadAsClass() throws ClassNotFoundException, IOException, ClassFormatError {
        if (this.clazz == null) {
            ClassLoader loader = this.scanner.getLoader();
            this.clazz = loader instanceof ScannedItemClassLoader ? ((ScannedItemClassLoader)loader).loadClass(this) : loader.loadClass(this.getClassName());
        }
        return this.clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties loadAsProperties() throws IOException, IllegalArgumentException {
        if (this.properties == null) {
            InputStream is = null;
            try {
                is = this.getInputStream();
                this.properties = new Properties();
                this.properties.load(this.getInputStream());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return this.properties;
    }

    public String toString() {
        if (this.marker != null) {
            return this.getAbsolutePath() + " [marker=" + this.marker + "]";
        }
        return this.getAbsolutePath();
    }
}

