/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.granite.scan.AbstractScannedItem;
import org.granite.scan.Scanner;

public class FileScannedItem
extends AbstractScannedItem {
    private final File root;
    private final File file;
    private String relativePath = null;

    public FileScannedItem(Scanner scanner, FileScannedItem marker, File root, File file) {
        super(scanner, marker);
        this.root = root;
        this.file = file;
    }

    public File getRoot() {
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.file.length();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String getName() {
        return this.file.getName();
    }

    public String getRelativePath() {
        if (this.relativePath == null) {
            StringBuffer sb = new StringBuffer();
            for (File f = this.file; f != null && !this.root.equals(f); f = f.getParentFile()) {
                if (sb.length() > 0) {
                    sb.insert(0, '/');
                }
                sb.insert(0, f.getName());
            }
            this.relativePath = sb.toString();
        }
        return this.relativePath;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FileScannedItem)) {
            return false;
        }
        return this.file.equals(((FileScannedItem)obj).file) && this.root.equals(((FileScannedItem)obj).root);
    }

    public int hashCode() {
        return this.root.hashCode() + 31 * this.file.hashCode();
    }
}

