/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.invocation;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String componentName;
    private String componentClassName;
    private String expression;
    private Object value;
    private int scope;
    private boolean restrict;
    private Class<?> componentClass;

    public ContextUpdate() {
    }

    public ContextUpdate(String componentName, String expression, Object value, int scope, boolean restrict) {
        this.componentName = componentName;
        this.expression = expression;
        this.value = value;
        this.scope = scope;
        this.restrict = restrict;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    public Class<?> getComponentClass() {
        if (this.componentClassName == null) {
            return null;
        }
        if (this.componentClass == null) {
            try {
                this.componentClass = Thread.currentThread().getContextClassLoader().loadClass(this.componentClassName);
            }
            catch (Exception e) {
                throw new RuntimeException("Component class not found", e);
            }
        }
        return this.componentClass;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public boolean getRestrict() {
        return this.restrict;
    }

    public void setRestrict(boolean restrict) {
        this.restrict = restrict;
    }

    public String toString() {
        return this.componentName + (this.componentClassName != null ? "(" + this.componentClassName + ")" : "") + (this.expression != null ? "." + this.expression : "") + (this.scope == 1 ? " (SESSION)" : (this.scope == 2 ? " (CONVERSATION)" : "")) + (this.restrict ? " (restricted)" : "");
    }
}

