/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.gsp;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.granite.generator.gsp.GroovyTemplate;

public class GroovyTemplateFactory {
    private final Map<URI, GroovyTemplate> templatesMap = new HashMap<URI, GroovyTemplate>();

    public boolean isOutdated() {
        for (GroovyTemplate template : this.templatesMap.values()) {
            if (!template.isOutdated()) continue;
            return true;
        }
        return false;
    }

    public void cleanOutdated() {
        ArrayList<URI> outdated = new ArrayList<URI>();
        for (GroovyTemplate template : this.templatesMap.values()) {
            if (!template.isOutdated()) continue;
            outdated.add(template.getUri());
        }
        for (URI uri : outdated) {
            this.templatesMap.remove(uri);
        }
    }

    public void clear() {
        this.templatesMap.clear();
    }

    public void clear(URI uri) {
        this.templatesMap.remove(uri);
    }

    public GroovyTemplate getTemplate(URI uri, boolean baseTemplate) {
        return this.getTemplate(uri, baseTemplate, Charset.defaultCharset());
    }

    public GroovyTemplate getTemplate(URI uri, boolean baseTemplate, Charset charset) {
        if (uri == null || charset == null) {
            throw new IllegalArgumentException("uri and charset cannot be null");
        }
        GroovyTemplate template = this.templatesMap.get(uri);
        if (template == null) {
            template = new GroovyTemplate(uri, baseTemplate, charset);
            this.templatesMap.put(uri, template);
        }
        return template;
    }
}

