/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.graphwalker.io.common.ResourceNotFoundException;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static File getResourceAsFile(String filename) {
        File file = ResourceUtils.createFile(filename);
        if (file.exists()) {
            return file;
        }
        URL resource = ResourceUtils.class.getResource(filename);
        if (null == resource) {
            resource = Thread.currentThread().getContextClassLoader().getResource(filename);
        }
        if (null != resource) {
            return new File(resource.getFile());
        }
        throw new ResourceNotFoundException();
    }

    public static InputStream getResourceAsStream(String filename) {
        File file = ResourceUtils.createFile(filename);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException();
            }
        }
        InputStream resource = ResourceUtils.class.getResourceAsStream(filename);
        if (null == resource) {
            resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        }
        if (null != resource) {
            return resource;
        }
        throw new ResourceNotFoundException();
    }

    private static String[] splitPath(String filename) {
        return filename.split("[\\\\/]");
    }

    private static File createFile(String filename) {
        File createdFile = null;
        for (String part : ResourceUtils.splitPath(filename)) {
            createdFile = new File(createdFile, part);
        }
        return createdFile;
    }
}

