/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public final class ContextFactoryScanner {
    private static Map<Class<? extends ContextFactory>, ContextFactory> factories;

    private static String getExtension(String path) {
        int position = path.lastIndexOf(46);
        return path.lastIndexOf(File.separator) > position ? "" : path.substring(position + 1);
    }

    private static boolean valid(URL url) {
        String extension = ContextFactoryScanner.getExtension(url.getPath());
        return "".equals(extension) || "jar".equals(extension);
    }

    private static Collection<URL> getUrls() {
        HashSet<URL> filteredUrls = new HashSet<URL>();
        HashSet urls = new HashSet();
        urls.addAll(ClasspathHelper.forClassLoader());
        urls.addAll(ClasspathHelper.forJavaClassPath());
        for (URL url : urls) {
            if (!ContextFactoryScanner.valid(url)) continue;
            filteredUrls.add(url);
        }
        return filteredUrls;
    }

    public static ContextFactory get(Path path) {
        return ContextFactoryScanner.get(new Reflections((Configuration)new ConfigurationBuilder().addUrls(ContextFactoryScanner.getUrls()).addScanners(new Scanner[]{new SubTypesScanner()})), path);
    }

    public static ContextFactory get(Reflections reflections, Path path) {
        for (Class factoryClass : reflections.getSubTypesOf(ContextFactory.class)) {
            ContextFactory factory = ContextFactoryScanner.create(factoryClass);
            if (null == factory || !factory.accept(path)) continue;
            return factory;
        }
        throw new ContextFactoryException("No suitable context factory found");
    }

    private static ContextFactory create(Class<? extends ContextFactory> factoryClass) {
        if (!factories.containsKey(factoryClass)) {
            try {
                factories.put(factoryClass, factoryClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                return null;
            }
        }
        return factories.get(factoryClass);
    }

    static {
        Reflections.log = null;
        factories = new HashMap<Class<? extends ContextFactory>, ContextFactory>();
    }
}

