/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.dot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.dsl.antlr.dot.AntlrDotListener;
import org.graphwalker.dsl.dot.DOTLexer;
import org.graphwalker.dsl.dot.DOTParser;
import org.graphwalker.io.common.ResourceUtils;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.dot.DotContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DotContextFactory
implements ContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(DotContextFactory.class);
    private static final String FILE_TYPE = "dot";
    private static final Set<String> SUPPORTED_TYPE = new HashSet<String>(Arrays.asList("**/*.dot"));
    private Vertex startVertex = null;
    private Edge startEdge = null;
    private Map<String, Vertex> elements = new HashMap<String, Vertex>();

    @Override
    public Set<String> getSupportedFileTypes() {
        return SUPPORTED_TYPE;
    }

    @Override
    public boolean accept(Path path) {
        return path.toFile().toString().endsWith(FILE_TYPE);
    }

    @Override
    public Context create(Path path) {
        return this.create(path, new DotContext());
    }

    @Override
    public <T extends Context> T create(Path path, T context) {
        Model model = new Model();
        BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceAsStream(path.toString())));
        StringBuilder out = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
        }
        catch (IOException e) {
            throw new ContextFactoryException("Could not read the file.");
        }
        logger.debug(out.toString());
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new ContextFactoryException("Could not read the file.");
        }
        DOTLexer lexer = new DOTLexer((CharStream)new ANTLRInputStream(out.toString()));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        DOTParser parser = new DOTParser((TokenStream)tokens);
        ParseTreeWalker walker = new ParseTreeWalker();
        AntlrDotListener listener = new AntlrDotListener();
        walker.walk((ParseTreeListener)listener, (ParseTree)parser.graph());
        Edge startEdge = null;
        for (Vertex vertex : listener.vertices.values()) {
            if (vertex.getName().equalsIgnoreCase("START")) continue;
            model.addVertex(vertex);
        }
        for (Edge edge : listener.edges) {
            if (edge.getSourceVertex().getName() != null && edge.getSourceVertex().getName().equalsIgnoreCase("START")) {
                edge.setSourceVertex(null);
                startEdge = edge;
            }
            model.addEdge(edge);
        }
        model.setName(path.toString());
        context.setModel(model.build());
        if (null != startEdge) {
            context.setNextElement(startEdge);
        } else {
            for (Vertex vertex : context.getModel().getVertices()) {
                if (!context.getModel().getOutEdges((Vertex.RuntimeVertex)vertex).isEmpty()) continue;
                context.setNextElement((Element)vertex);
            }
        }
        return context;
    }
}

