/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.common.ResourceUtils;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.json.JsonContext;
import org.graphwalker.io.factory.json.JsonModel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonContextFactory
implements ContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonContextFactory.class);
    private static final String FILE_TYPE = "json";
    private static final Set<String> SUPPORTED_TYPE = new HashSet<String>(Arrays.asList("**/*.json"));

    @Override
    public <T extends Context> T create(Path path, T context) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceAsStream(path.toString())));
        StringBuilder out = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
        }
        catch (IOException e) {
            throw new ContextFactoryException("Could not read the file.");
        }
        logger.debug(out.toString());
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new ContextFactoryException("Could not read the file.");
        }
        this.create(out.toString(), context);
        return context;
    }

    public <T extends Context> T create(String jsonString, T context) {
        Element startElement = null;
        HashMap<String, Vertex> elements = new HashMap<String, Vertex>();
        Model gwModel = new Model();
        JSONObject root = new JSONObject(jsonString);
        JSONArray vertices = root.getJSONArray("vertices");
        for (int vertexIndex = 0; vertexIndex < vertices.length(); ++vertexIndex) {
            JSONObject vertex = vertices.getJSONObject(vertexIndex);
            logger.debug("New vertex");
            Vertex v = new Vertex().setId(vertex.getString("id")).setName(vertex.getString("name"));
            logger.debug("  id: " + vertex.getString("id"));
            logger.debug("  name: " + vertex.getString("name"));
            gwModel.addVertex(v);
            elements.put(v.getId(), v);
            try {
                if (!vertex.getBoolean("startElement")) continue;
                logger.debug("  startElement: " + vertex.getBoolean("startElement"));
                startElement = (Element)v.build();
                continue;
            }
            catch (JSONException ex) {
                // empty catch block
            }
        }
        JSONArray edges = root.getJSONArray("edges");
        for (int edgeIndex = 0; edgeIndex < edges.length(); ++edgeIndex) {
            JSONObject edge = edges.getJSONObject(edgeIndex);
            logger.debug("New edge");
            Edge e = new Edge().setId(edge.getString("id")).setName(edge.getString("name"));
            logger.debug("  id: " + edge.getString("id"));
            logger.debug("  name: " + edge.getString("name"));
            try {
                e.setSourceVertex((Vertex)elements.get(edge.getString("srcVertexId")));
                logger.debug("  srcVertexId: " + edge.getString("srcVertexId"));
            }
            catch (JSONException ex) {
                // empty catch block
            }
            try {
                JSONArray actions = edge.getJSONArray("actions");
                for (int actionIndex = 0; actionIndex < vertices.length(); ++actionIndex) {
                    JSONObject action = actions.getJSONObject(actionIndex);
                    e.addAction(new Action(action.getString("action")));
                    logger.debug("  action: " + action.getString("action"));
                }
            }
            catch (JSONException ex) {
                // empty catch block
            }
            e.setTargetVertex((Vertex)elements.get(edge.getString("dstVertexId")));
            logger.debug("  dstVertexId: " + edge.getString("dstVertexId"));
            gwModel.addEdge(e);
            try {
                if (!edge.getBoolean("startElement")) continue;
                logger.debug("  startElement: " + edge.getBoolean("startElement"));
                startElement = (Element)e.build();
                continue;
            }
            catch (JSONException ex) {
                // empty catch block
            }
        }
        gwModel.setName(root.getString("name"));
        logger.debug("Model name: " + root.getString("name"));
        context.setModel(gwModel.build());
        context.setPathGenerator(GeneratorFactory.parse((String)root.getString("generator")));
        logger.debug("Generator: " + root.getString("generator"));
        context.setNextElement(startElement);
        return context;
    }

    @Override
    public Set<String> getSupportedFileTypes() {
        return SUPPORTED_TYPE;
    }

    @Override
    public boolean accept(Path path) {
        boolean accept = path.toFile().toString().endsWith(FILE_TYPE);
        if (accept) {
            InputStreamReader reader = new InputStreamReader(ResourceUtils.getResourceAsStream(path.toString()));
            Gson gson = new GsonBuilder().create();
            JsonModel model = (JsonModel)gson.fromJson((Reader)reader, JsonModel.class);
            accept = model.isModel();
        }
        return accept;
    }

    @Override
    public Context create(Path path) {
        return this.create(path, new JsonContext());
    }

    public Context create(String jsonString) {
        return this.create(jsonString, new JsonContext());
    }
}

