/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.yed;

import com.yworks.xml.graphml.ArcEdgeDocument;
import com.yworks.xml.graphml.BezierEdgeDocument;
import com.yworks.xml.graphml.EdgeLabelType;
import com.yworks.xml.graphml.EdgeType;
import com.yworks.xml.graphml.GenericEdgeDocument;
import com.yworks.xml.graphml.GenericGroupNodeDocument;
import com.yworks.xml.graphml.GenericNodeDocument;
import com.yworks.xml.graphml.GroupNodeDocument;
import com.yworks.xml.graphml.ImageNodeDocument;
import com.yworks.xml.graphml.NodeLabelType;
import com.yworks.xml.graphml.NodeType;
import com.yworks.xml.graphml.PolyLineEdgeDocument;
import com.yworks.xml.graphml.QuadCurveEdgeDocument;
import com.yworks.xml.graphml.ShapeNodeDocument;
import com.yworks.xml.graphml.SplineEdgeDocument;
import com.yworks.xml.graphml.TableNodeDocument;
import com.yworks.xml.graphml.impl.EdgeLabelTypeImpl;
import com.yworks.xml.graphml.impl.NodeLabelTypeImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.graphdrawing.graphml.xmlns.DataType;
import org.graphdrawing.graphml.xmlns.GraphType;
import org.graphdrawing.graphml.xmlns.GraphmlDocument;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Builder;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Guard;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.dsl.antlr.yed.YEdDescriptiveErrorListener;
import org.graphwalker.dsl.yed.YEdEdgeParser;
import org.graphwalker.dsl.yed.YEdLabelLexer;
import org.graphwalker.dsl.yed.YEdVertexParser;
import org.graphwalker.io.common.ResourceNotFoundException;
import org.graphwalker.io.common.ResourceUtils;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.yed.YEdContext;

public final class YEdContextFactory
implements ContextFactory {
    private static final String NAMESPACE = "declare namespace xq='http://graphml.graphdrawing.org/xmlns';";
    private static final String FILE_TYPE = "graphml";
    private static final Set<String> SUPPORTED_TYPE = new HashSet<String>(Arrays.asList("**/*.graphml"));

    @Override
    public Set<String> getSupportedFileTypes() {
        return SUPPORTED_TYPE;
    }

    @Override
    public boolean accept(Path path) {
        return path.toFile().toString().endsWith(FILE_TYPE);
    }

    @Override
    public Context create(Path path) {
        return this.create(path, new YEdContext());
    }

    @Override
    public <T extends Context> T create(Path path, T context) {
        Edge startEdge = null;
        HashMap<String, Vertex> elements = new HashMap<String, Vertex>();
        Model model = new Model();
        GraphmlDocument document = null;
        try {
            document = GraphmlDocument.Factory.parse(ResourceUtils.getResourceAsStream(path.toString()));
        }
        catch (XmlException e) {
            throw new ContextFactoryException("The file appears not to be valid yEd formatted.");
        }
        catch (IOException e) {
            throw new ContextFactoryException("Could not read the file.");
        }
        catch (ResourceNotFoundException e) {
            throw new ContextFactoryException("Could not read the file.");
        }
        try {
            Vertex startVertex = this.addVertices(model, context, document, elements);
            startEdge = this.addEdges(model, context, document, elements, startVertex);
        }
        catch (XmlException e) {
            throw new ContextFactoryException("The file seems not to be of valid yEd format.");
        }
        model.setName(path.toString());
        context.setModel(model.build());
        if (null != startEdge) {
            context.setNextElement((Builder)startEdge);
        }
        for (Vertex.RuntimeVertex vertex : context.getModel().getVertices()) {
            if (0 != context.getModel().getInEdges(vertex).size() || vertex.equals(context.getNextElement()) || vertex.hasSharedState()) continue;
            throw new ContextFactoryException("No in-edges! Vertex: '" + (vertex.hasName() ? vertex.getName() : vertex.getId()) + "'");
        }
        return context;
    }

    private Vertex addVertices(Model model, Context context, GraphmlDocument document, Map<String, Vertex> elements) throws XmlException {
        Vertex startVertex = null;
        ArrayDeque<XmlObject> workQueue = new ArrayDeque<XmlObject>();
        workQueue.addAll(Arrays.asList(document.selectPath("declare namespace xq='http://graphml.graphdrawing.org/xmlns';$this/xq:graphml/xq:graph/xq:node")));
        while (!workQueue.isEmpty()) {
            XmlObject object = (XmlObject)workQueue.pop();
            if (!(object instanceof org.graphdrawing.graphml.xmlns.NodeType)) continue;
            org.graphdrawing.graphml.xmlns.NodeType node = (org.graphdrawing.graphml.xmlns.NodeType)object;
            if (0 < node.getGraphArray().length) {
                for (GraphType subgraph : node.getGraphArray()) {
                    workQueue.addAll(Arrays.asList(subgraph.getNodeArray()));
                }
                continue;
            }
            for (DataType data : node.getDataArray()) {
                if (0 >= data.getDomNode().getChildNodes().getLength() || !this.isSupportedNode(data.xmlText())) continue;
                StringBuilder label = new StringBuilder();
                for (NodeLabelType nodeLabel : this.getSupportedNode(data.xmlText()).getNodeLabelArray()) {
                    label.append(((NodeLabelTypeImpl)nodeLabel).getStringValue());
                }
                YEdVertexParser parser = new YEdVertexParser((TokenStream)this.getTokenStream(label.toString()));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)YEdDescriptiveErrorListener.INSTANCE);
                YEdVertexParser.ParseContext parseContext = parser.parse();
                Vertex vertex = new Vertex();
                boolean blocked = false;
                if (null != parseContext.start()) {
                    elements.put(node.getId(), vertex);
                    vertex.setId(node.getId());
                    startVertex = vertex;
                    continue;
                }
                for (YEdVertexParser.FieldContext field : parseContext.field()) {
                    if (null != field.names()) {
                        vertex.setName(field.names().getText());
                    }
                    if (null != field.shared() && null != field.shared().Identifier()) {
                        vertex.setSharedState(field.shared().Identifier().getText());
                    }
                    if (null != field.reqtags()) {
                        vertex.addRequirements(this.convertVertexRequirement(field.reqtags().reqtagList().reqtag()));
                    }
                    if (null != field.actions()) {
                        model.addActions(this.convertVertexAction(field.actions().action()));
                    }
                    if (null == field.blocked()) continue;
                    blocked = true;
                }
                if (blocked) continue;
                elements.put(node.getId(), vertex);
                vertex.setId(node.getId());
                model.addVertex(vertex);
            }
        }
        return startVertex;
    }

    private boolean isSupportedNode(String xml) {
        return xml.contains("GenericNode") || xml.contains("ShapeNode") || xml.contains("GenericGroupNode") || xml.contains("GroupNode") || xml.contains("ImageNode") || xml.contains("TableNode");
    }

    private NodeType getSupportedNode(String xml) throws XmlException {
        if (xml.contains("GenericNode")) {
            return GenericNodeDocument.Factory.parse(xml).getGenericNode();
        }
        if (xml.contains("ShapeNode")) {
            return ShapeNodeDocument.Factory.parse(xml).getShapeNode();
        }
        if (xml.contains("GenericGroupNode")) {
            return GenericGroupNodeDocument.Factory.parse(xml).getGenericGroupNode();
        }
        if (xml.contains("GroupNode")) {
            return GroupNodeDocument.Factory.parse(xml).getGroupNode();
        }
        if (xml.contains("ImageNode")) {
            return ImageNodeDocument.Factory.parse(xml).getImageNode();
        }
        if (xml.contains("TableNode")) {
            return TableNodeDocument.Factory.parse(xml).getTableNode();
        }
        throw new ContextFactoryException("Unsupported node type: " + xml);
    }

    private Edge addEdges(Model model, Context context, GraphmlDocument document, Map<String, Vertex> elements, Vertex startVertex) throws XmlException {
        Edge startEdge = null;
        for (XmlObject object : document.selectPath("declare namespace xq='http://graphml.graphdrawing.org/xmlns';$this/xq:graphml/xq:graph/xq:edge")) {
            if (!(object instanceof org.graphdrawing.graphml.xmlns.EdgeType)) continue;
            org.graphdrawing.graphml.xmlns.EdgeType edgeType = (org.graphdrawing.graphml.xmlns.EdgeType)object;
            for (DataType data : edgeType.getDataArray()) {
                if (0 >= data.getDomNode().getChildNodes().getLength() || !this.isSupportedEdge(data.xmlText())) continue;
                StringBuilder label = new StringBuilder();
                for (EdgeLabelType edgeLabel : this.getSupportedEdge(data.xmlText()).getEdgeLabelArray()) {
                    label.append(((EdgeLabelTypeImpl)edgeLabel).getStringValue());
                }
                YEdEdgeParser parser = new YEdEdgeParser((TokenStream)this.getTokenStream(label.toString()));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)YEdDescriptiveErrorListener.INSTANCE);
                YEdEdgeParser.ParseContext parseContext = parser.parse();
                Edge edge = new Edge();
                if (null != elements.get(edgeType.getSource())) {
                    edge.setSourceVertex(elements.get(edgeType.getSource()));
                }
                if (null != elements.get(edgeType.getTarget())) {
                    edge.setTargetVertex(elements.get(edgeType.getTarget()));
                }
                boolean blocked = false;
                for (YEdEdgeParser.FieldContext field : parseContext.field()) {
                    if (null != field.names()) {
                        edge.setName(field.names().getText());
                    }
                    if (null != field.guard()) {
                        String text = field.guard().getText().trim();
                        edge.setGuard(new Guard(text.substring(1, text.length() - 1)));
                    }
                    if (null != field.actions()) {
                        edge.addActions(this.convertEdgeAction(field.actions().action()));
                    }
                    if (null != field.reqtags()) {
                        edge.addRequirements(this.convertEdgeRequirement(field.reqtags().reqtagList().reqtag()));
                    }
                    if (null == field.blocked()) continue;
                    blocked = true;
                }
                if (blocked || null == edge.getTargetVertex()) continue;
                if (null != startVertex && edgeType.getSource().equals(startVertex.getId())) {
                    edge.setSourceVertex(null);
                    edge.setId(edgeType.getId());
                    model.addEdge(edge);
                    startEdge = edge;
                    continue;
                }
                if (null == edge.getSourceVertex()) continue;
                edge.setId(edgeType.getId());
                model.addEdge(edge);
            }
        }
        return startEdge;
    }

    private boolean isSupportedEdge(String xml) {
        return xml.contains("PolyLineEdge") || xml.contains("GenericEdge") || xml.contains("ArcEdge") || xml.contains("QuadCurveEdge") || xml.contains("SplineEdge") || xml.contains("BezierEdge");
    }

    private EdgeType getSupportedEdge(String xml) throws XmlException {
        if (xml.contains("GenericEdge")) {
            return GenericEdgeDocument.Factory.parse(xml).getGenericEdge();
        }
        if (xml.contains("PolyLineEdge")) {
            return PolyLineEdgeDocument.Factory.parse(xml).getPolyLineEdge();
        }
        if (xml.contains("ArcEdge")) {
            return ArcEdgeDocument.Factory.parse(xml).getArcEdge();
        }
        if (xml.contains("QuadCurveEdge")) {
            return QuadCurveEdgeDocument.Factory.parse(xml).getQuadCurveEdge();
        }
        if (xml.contains("SplineEdge")) {
            return SplineEdgeDocument.Factory.parse(xml).getSplineEdge();
        }
        if (xml.contains("BezierEdge")) {
            return BezierEdgeDocument.Factory.parse(xml).getBezierEdge();
        }
        throw new ContextFactoryException("Unsupported edge type: " + xml);
    }

    private List<Action> convertEdgeAction(List<YEdEdgeParser.ActionContext> actionContexts) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (YEdEdgeParser.ActionContext actionContext : actionContexts) {
            actions.add(new Action(actionContext.getText()));
        }
        return actions;
    }

    private List<Action> convertVertexAction(List<YEdVertexParser.ActionContext> actionContexts) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (YEdVertexParser.ActionContext actionContext : actionContexts) {
            actions.add(new Action(actionContext.getText()));
        }
        return actions;
    }

    private Set<Requirement> convertEdgeRequirement(List<YEdEdgeParser.ReqtagContext> reqtagContexts) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (YEdEdgeParser.ReqtagContext reqtagContext : reqtagContexts) {
            requirements.add(new Requirement(reqtagContext.getText()));
        }
        return requirements;
    }

    private Set<Requirement> convertVertexRequirement(List<YEdVertexParser.ReqtagContext> reqtagContexts) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (YEdVertexParser.ReqtagContext reqtagContext : reqtagContexts) {
            requirements.add(new Requirement(reqtagContext.getText()));
        }
        return requirements;
    }

    private CommonTokenStream getTokenStream(String label) {
        ANTLRInputStream inputStream = new ANTLRInputStream(label);
        YEdLabelLexer lexer = new YEdLabelLexer((CharStream)inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)YEdDescriptiveErrorListener.INSTANCE);
        return new CommonTokenStream((TokenSource)lexer);
    }
}

