/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.spring;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.cache.GridCacheProjection;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.CAX;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.U;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

class GridSpringCache
implements Cache,
Serializable {
    private static final boolean DEBUG = Boolean.getBoolean("GRIDGAIN_SPRING_CACHE_DEBUG");
    private GridLogger log;
    private String name;
    private GridCacheProjection<Object, Object> cache;
    private GridClosure<Object, Object> keyFactory;

    GridSpringCache(GridLogger log, String name, GridCacheProjection<?, ?> cache, GridClosure<Object, Object> keyFactory) {
        assert (cache != null);
        this.log = log;
        this.name = name;
        this.cache = cache;
        this.keyFactory = keyFactory != null ? keyFactory : F.identity();
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        try {
            long s = DEBUG ? System.currentTimeMillis() : 0L;
            Object val = this.cache.get(this.keyFactory.apply(key));
            if (DEBUG) {
                long d = System.currentTimeMillis() - s;
                this.debug("Spring Cache Get [cache=" + this.name + ", key=" + key + ", time=" + d + "ms.]");
            }
            return val != null ? new SimpleValueWrapper(val) : null;
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to get value from cache [cacheName=" + this.cache.name() + ", key=" + key + ']', (Throwable)e);
        }
    }

    public <T> T get(Object key, Class<T> type) {
        try {
            long s = DEBUG ? System.currentTimeMillis() : 0L;
            Object val = this.cache.get(this.keyFactory.apply(key));
            if (DEBUG) {
                long d = System.currentTimeMillis() - s;
                this.debug(">>> Spring Cache Typed Get [cache=" + this.name + ", key=" + key + ", time=" + d + "ms.]");
            }
            if (val != null && type != null && !type.isInstance(val)) {
                throw new IllegalStateException("Cached value is not of required type [cacheName=" + this.cache.name() + ", key=" + key + ", val=" + val + ", requiredType=" + type + ']');
            }
            return (T)val;
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to get value from cache [cacheName=" + this.cache.name() + ", key=" + key + ']', (Throwable)e);
        }
    }

    public void put(Object key, Object val) {
        try {
            long s = DEBUG ? System.currentTimeMillis() : 0L;
            this.cache.putx(this.keyFactory.apply(key), val, new GridPredicate[0]);
            if (DEBUG) {
                long d = System.currentTimeMillis() - s;
                this.debug("Spring Cache Put [cache=" + this.name + ", key=" + key + ", time=" + d + "ms.]");
            }
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to put value to cache [cacheName=" + this.cache.name() + ", key=" + key + ", val=" + val + ']', (Throwable)e);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object val) {
        try {
            long s = DEBUG ? System.currentTimeMillis() : 0L;
            Object old = this.cache.putIfAbsent(this.keyFactory.apply(key), val);
            if (DEBUG) {
                long d = System.currentTimeMillis() - s;
                this.debug("Spring Cache Put-If-Absent [cache=" + this.name + ", key=" + key + ", time=" + d + "ms.]");
            }
            return old != null ? new SimpleValueWrapper(old) : null;
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to put value to cache [cacheName=" + this.cache.name() + ", key=" + key + ", val=" + val + ']', (Throwable)e);
        }
    }

    public void evict(Object key) {
        try {
            this.cache.removex(this.keyFactory.apply(key), new GridPredicate[0]);
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to remove value from cache [cacheName=" + this.cache.name() + ", key=" + key + ']', (Throwable)e);
        }
    }

    public void clear() {
        try {
            this.cache.gridProjection().compute().broadcast((Runnable)((Object)new ClearClosure(this.cache))).get();
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to clear cache [cacheName=" + this.cache.name() + ']', (Throwable)e);
        }
    }

    private void debug(String msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg);
        }
        System.out.println(U.debugPrefix() + msg);
    }

    private static class ClearClosure
    extends CAX
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridCacheProjection<Object, Object> cache;

        public ClearClosure() {
        }

        private ClearClosure(GridCacheProjection<Object, Object> cache) {
            this.cache = cache;
        }

        public void applyx() throws GridException {
            this.cache.removeAll(new GridPredicate[0]);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.cache);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cache = (GridCacheProjection)in.readObject();
        }
    }
}

