/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.spring;

import java.util.Collection;
import org.gridgain.grid.GridConfiguration;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheProjection;
import org.gridgain.grid.cache.spring.GridSpringCache;
import org.gridgain.grid.kernal.GridEx;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.util.typedef.F;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class GridSpringCacheManager
implements CacheManager,
InitializingBean {
    private String cfgPath;
    private GridConfiguration cfg;
    private String gridName;
    protected GridEx grid;

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public GridConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(GridConfiguration cfg) {
        this.cfg = cfg;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.grid == null);
        if (this.cfgPath != null && this.cfg != null) {
            throw new IllegalArgumentException("Both 'configurationPath' and 'configuration' are provided. Set only one of these properties if you need to start a GridGain node inside of GridSpringCacheManager. If you already have a node running, omit both of them and set'gridName' property.");
        }
        this.grid = this.cfgPath != null ? (GridEx)GridGain.start((String)this.cfgPath) : (this.cfg != null ? (GridEx)GridGain.start((GridConfiguration)this.cfg) : (GridEx)GridGain.grid((String)this.gridName));
    }

    public Cache getCache(String name) {
        assert (this.grid != null);
        try {
            return new GridSpringCache(this.grid.log().getLogger(this.getClass()), name, (GridCacheProjection<?, ?>)this.grid.cache(name), null);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public Collection<String> getCacheNames() {
        assert (this.grid != null);
        return F.viewReadOnly((Collection)this.grid.caches(), (GridClosure)new GridClosure<GridCache<?, ?>, String>(){

            public String apply(GridCache<?, ?> c) {
                return c.name();
            }
        }, (GridPredicate[])new GridPredicate[0]);
    }
}

