/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.spring;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.spring.GridSpringCache;
import org.gridgain.grid.cache.spring.GridSpringCacheManager;
import org.gridgain.grid.kernal.processors.cache.GridCacheProjectionEx;
import org.gridgain.grid.kernal.processors.cache.GridCacheUtilityKey;
import org.gridgain.grid.lang.GridBiPredicate;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.springframework.cache.Cache;

public class GridSpringDynamicCacheManager
extends GridSpringCacheManager {
    private String dataCacheName;
    private GridCacheProjectionEx<MetaKey, Cache> metaCache;
    private GridCache<DataKey, Object> dataCache;

    public String getDataCacheName() {
        return this.dataCacheName;
    }

    public void setDataCacheName(String dataCacheName) {
        this.dataCacheName = dataCacheName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.metaCache = this.grid.utilityCache(MetaKey.class, Cache.class);
        this.dataCache = this.grid.cache(this.dataCacheName);
    }

    @Override
    public Cache getCache(final String name) {
        Cache cache = super.getCache(name);
        if (cache != null) {
            return cache;
        }
        try {
            Cache old;
            MetaKey key = new MetaKey(name);
            cache = (Cache)this.metaCache.get((Object)key);
            if (cache == null && (old = (Cache)this.metaCache.putIfAbsent((Object)key, (Object)(cache = new GridSpringCache(this.grid.log().getLogger(this.getClass()), name, this.dataCache.projection((GridBiPredicate)new ProjectionFilter(name)), new GridClosure<Object, Object>(){

                public Object apply(Object o) {
                    return new DataKey(name, o);
                }
            })))) != null) {
                cache = old;
            }
            return cache;
        }
        catch (GridException e) {
            throw new GridRuntimeException((Throwable)e);
        }
    }

    @Override
    public Collection<String> getCacheNames() {
        Collection names = F.view(super.getCacheNames(), (GridPredicate[])new GridPredicate[]{new GridPredicate<String>(){

            public boolean apply(String name) {
                return !F.eq((Object)name, (Object)GridSpringDynamicCacheManager.this.dataCacheName);
            }
        }});
        return F.concat((boolean)false, (Collection)names, (Collection)F.transform((Collection)this.metaCache.entrySetx(new GridPredicate[0]), (GridClosure)new GridClosure<Map.Entry<MetaKey, Cache>, String>(){

            public String apply(Map.Entry<MetaKey, Cache> e) {
                return e.getKey().name;
            }
        }));
    }

    private static class ProjectionFilter
    implements GridBiPredicate<DataKey, Object>,
    Externalizable {
        private String name;

        public ProjectionFilter() {
        }

        private ProjectionFilter(String name) {
            this.name = name;
        }

        public boolean apply(DataKey key, Object val) {
            return this.name != null ? this.name.equals(key.name) : key.name == null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(ProjectionFilter.class, (Object)this);
        }
    }

    private static class DataKey
    implements Externalizable {
        private String name;
        @GridToStringInclude
        private Object key;

        private DataKey(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public DataKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataKey key0 = (DataKey)o;
            return this.name != null ? this.name.equals(key0.name) : (key0.name == null && this.key != null ? this.key.equals(key0.key) : key0.key == null);
        }

        public int hashCode() {
            int res = this.name != null ? this.name.hashCode() : 0;
            res = 31 * res + (this.key != null ? this.key.hashCode() : 0);
            return res;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.name);
            out.writeObject(this.key);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString((DataInput)in);
            this.key = in.readObject();
        }

        public String toString() {
            return S.toString(DataKey.class, (Object)this);
        }
    }

    private static class MetaKey
    extends GridCacheUtilityKey<MetaKey>
    implements Externalizable {
        private String name;

        public MetaKey() {
        }

        private MetaKey(String name) {
            this.name = name;
        }

        protected boolean equalsx(MetaKey key) {
            return this.name != null ? this.name.equals(key.name) : key.name == null;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(MetaKey.class, (Object)this);
        }
    }
}

