/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.resource;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.managers.deployment.GridDeployment;
import org.gridgain.grid.kernal.processors.resource.GridResourceField;
import org.gridgain.grid.kernal.processors.resource.GridResourceInjector;
import org.gridgain.grid.kernal.processors.resource.GridResourceMethod;
import org.gridgain.grid.kernal.processors.resource.GridResourceUtils;
import org.gridgain.grid.resources.GridSpringResource;
import org.gridgain.grid.util.typedef.internal.S;
import org.springframework.context.ApplicationContext;

public class GridResourceSpringBeanInjector
implements GridResourceInjector {
    private ApplicationContext springCtx;

    public GridResourceSpringBeanInjector(ApplicationContext springCtx) {
        this.springCtx = springCtx;
    }

    public void inject(GridResourceField field, Object target, Class<?> cls, GridDeployment depCls) throws GridException {
        GridSpringResource ann = (GridSpringResource)field.getAnnotation();
        assert (ann != null);
        if (!Modifier.isTransient(field.getField().getModifiers()) && Serializable.class.isAssignableFrom(field.getField().getDeclaringClass())) {
            throw new GridException("@GridSpringResource must only be used with 'transient' fields: " + field.getField());
        }
        String name = ann.resourceName();
        if (this.springCtx != null) {
            Object bean = this.springCtx.getBean(name);
            GridResourceUtils.inject((Field)field.getField(), (Object)target, (Object)bean);
        }
    }

    public void inject(GridResourceMethod mtd, Object target, Class<?> cls, GridDeployment depCls) throws GridException {
        GridSpringResource ann = (GridSpringResource)mtd.getAnnotation();
        assert (ann != null);
        if (mtd.getMethod().getParameterTypes().length != 1) {
            throw new GridException("Method injection setter must have only one parameter: " + mtd.getMethod());
        }
        String name = ann.resourceName();
        if (this.springCtx != null) {
            Object bean = this.springCtx.getBean(name);
            GridResourceUtils.inject((Method)mtd.getMethod(), (Object)target, (Object)bean);
        }
    }

    public void undeploy(GridDeployment dep) {
    }

    public String toString() {
        return S.toString(GridResourceSpringBeanInjector.class, (Object)this);
    }
}

