/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.spring;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.gridgain.grid.GridConfiguration;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.processors.resource.GridSpringResourceContext;
import org.gridgain.grid.kernal.processors.resource.GridSpringResourceContextImpl;
import org.gridgain.grid.kernal.processors.spring.GridSpringProcessor;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class GridSpringProcessorImpl
implements GridSpringProcessor {
    public static final String GRIDGAIN_XML_PATH = "META-INF/gridgain.xml";
    private static final AtomicReference<String> SYS_LDR_VER = new AtomicReference<Object>(null);

    public GridBiTuple<Collection<GridConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(URL cfgUrl, String ... excludedProps) throws GridException {
        Map cfgMap;
        ApplicationContext springCtx;
        try {
            springCtx = GridSpringProcessorImpl.applicationContext(cfgUrl, excludedProps);
        }
        catch (BeansException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) {
                throw new GridException("Failed to instantiate Spring XML application context (make sure all classes used in Spring configuration are present at CLASSPATH) [springUrl=" + cfgUrl + ']', (Throwable)e);
            }
            throw new GridException("Failed to instantiate Spring XML application context [springUrl=" + cfgUrl + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        try {
            cfgMap = springCtx.getBeansOfType(GridConfiguration.class);
        }
        catch (BeansException e) {
            throw new GridException("Failed to instantiate bean [type=" + GridConfiguration.class + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new GridException("Failed to find grid configuration in: " + cfgUrl);
        }
        return F.t(cfgMap.values(), (Object)new GridSpringResourceContextImpl(springCtx));
    }

    public Map<Class<?>, Object> loadBeans(URL cfgUrl, Class<?> ... beanClasses) throws GridException {
        GenericApplicationContext springCtx;
        assert (beanClasses.length > 0);
        try {
            springCtx = new GenericApplicationContext();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(cfgUrl));
            springCtx.refresh();
        }
        catch (BeansException e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) {
                throw new GridException("Failed to instantiate Spring XML application context (make sure all classes used in Spring configuration are present at CLASSPATH) [springUrl=" + cfgUrl + ']', (Throwable)e);
            }
            throw new GridException("Failed to instantiate Spring XML application context [springUrl=" + cfgUrl + ", err=" + e.getMessage() + ']', (Throwable)e);
        }
        HashMap beans = new HashMap();
        for (Class<?> cls : beanClasses) {
            beans.put(cls, GridSpringProcessorImpl.bean((ListableBeanFactory)springCtx, cls));
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String userVersion(ClassLoader ldr, GridLogger log) {
        assert (ldr != null);
        assert (log != null);
        if (ldr == U.gridClassLoader() && SYS_LDR_VER.get() != null) {
            return SYS_LDR_VER.get();
        }
        String usrVer = "0";
        InputStream in = ldr.getResourceAsStream(GRIDGAIN_XML_PATH);
        if (in != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                U.copy((InputStream)in, (OutputStream)out);
                DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
                XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)factory);
                reader.loadBeanDefinitions((Resource)new ByteArrayResource(out.toByteArray()));
                usrVer = (String)factory.getBean("userVersion");
                usrVer = usrVer == null ? "0" : usrVer.trim();
            }
            catch (NoSuchBeanDefinitionException ignored) {
                if (log.isInfoEnabled()) {
                    log.info("User version is not explicitly defined (will use default version) [file=META-INF/gridgain.xml, clsLdr=" + ldr + ']');
                }
                usrVer = "0";
            }
            catch (BeansException e) {
                U.error((GridLogger)log, (Object)("Failed to parse Spring XML file (will use default user version) [file=META-INF/gridgain.xml, clsLdr=" + ldr + ']'), (Throwable)e);
                usrVer = "0";
            }
            catch (IOException e) {
                U.error((GridLogger)log, (Object)("Failed to read Spring XML file (will use default user version) [file=META-INF/gridgain.xml, clsLdr=" + ldr + ']'), (Throwable)e);
                usrVer = "0";
            }
            finally {
                U.close((Closeable)out, (GridLogger)log);
            }
        }
        if (ldr == U.gridClassLoader()) {
            SYS_LDR_VER.compareAndSet(null, usrVer);
        }
        return usrVer;
    }

    @Nullable
    private static <T> T bean(ListableBeanFactory ctx, Class<T> beanCls) {
        Map.Entry entry = F.firstEntry((Map)ctx.getBeansOfType(beanCls));
        return entry == null ? null : (T)entry.getValue();
    }

    public static ApplicationContext applicationContext(URL cfgUrl, final String ... excludedProps) {
        GenericApplicationContext springCtx = new GenericApplicationContext();
        BeanFactoryPostProcessor postProc = new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                for (String beanName : beanFactory.getBeanDefinitionNames()) {
                    BeanDefinition def = beanFactory.getBeanDefinition(beanName);
                    if (def.getBeanClassName() != null) {
                        try {
                            Class.forName(def.getBeanClassName());
                        }
                        catch (ClassNotFoundException ignored) {
                            ((BeanDefinitionRegistry)beanFactory).removeBeanDefinition(beanName);
                            continue;
                        }
                    }
                    MutablePropertyValues vals = def.getPropertyValues();
                    for (PropertyValue val : new ArrayList(vals.getPropertyValueList())) {
                        for (String excludedProp : excludedProps) {
                            if (!val.getName().equals(excludedProp)) continue;
                            vals.removePropertyValue(val);
                        }
                    }
                }
            }
        };
        springCtx.addBeanFactoryPostProcessor(postProc);
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(cfgUrl));
        springCtx.refresh();
        return springCtx;
    }

    static {
        Class<?> logFactoryCls = null;
        try {
            logFactoryCls = Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (logFactoryCls != null) {
            try {
                Object factory = logFactoryCls.getMethod("getFactory", new Class[0]).invoke(null, new Object[0]);
                factory.getClass().getMethod("setAttribute", String.class, Object.class).invoke(factory, "org.apache.commons.logging.Log", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

