/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsMapContainingKey<K>
extends TypeSafeMatcher<Map<? super K, ?>> {
    private final Matcher<? super K> keyMatcher;

    public IsMapContainingKey(Matcher<? super K> keyMatcher) {
        this.keyMatcher = keyMatcher;
    }

    public boolean matchesSafely(Map<? super K, ?> item) {
        for (K key : item.keySet()) {
            if (!this.keyMatcher.matches(key)) continue;
            return true;
        }
        return false;
    }

    public void describeMismatchSafely(Map<? super K, ?> map, Description mismatchDescription) {
        mismatchDescription.appendText("map was ").appendValueList("[", ", ", "]", map.entrySet());
    }

    public void describeTo(Description description) {
        description.appendText("map with key ").appendDescriptionOf(this.keyMatcher);
    }

    @Factory
    public static <K> Matcher<Map<? super K, ?>> hasKey(K key) {
        return new IsMapContainingKey<K>(IsEqual.equalTo(key));
    }

    @Factory
    public static <K> Matcher<Map<? super K, ?>> hasKey(Matcher<? super K> keyMatcher) {
        return new IsMapContainingKey<K>(keyMatcher);
    }
}

