/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache;

import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheRegionFactory;
import org.hibernate.cache.spi.Region;

public class JCacheRegion
implements Region {
    protected final Cache<Object, Object> cache;

    public JCacheRegion(Cache<Object, Object> cache) {
        if (cache == null) {
            throw new NullPointerException("JCacheRegion requires a Cache!");
        }
        this.cache = cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public void destroy() throws CacheException {
        this.cache.getCacheManager().destroyCache(this.cache.getName());
    }

    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Cache.Entry entry : this.cache) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public long nextTimestamp() {
        return JCacheRegionFactory.nextTS();
    }

    public int getTimeout() {
        return JCacheRegionFactory.timeOut();
    }

    Cache<Object, Object> getCache() {
        return this.cache;
    }
}

