/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.MetaModelGenerationException;
import org.hibernate.jpamodelgen.model.ImportContext;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.XmlMetaCollection;
import org.hibernate.jpamodelgen.xml.XmlMetaMap;
import org.hibernate.jpamodelgen.xml.XmlMetaSingleAttribute;
import org.hibernate.jpamodelgen.xml.jaxb.AccessType;
import org.hibernate.jpamodelgen.xml.jaxb.Attributes;
import org.hibernate.jpamodelgen.xml.jaxb.Basic;
import org.hibernate.jpamodelgen.xml.jaxb.ElementCollection;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.EmbeddableAttributes;
import org.hibernate.jpamodelgen.xml.jaxb.Embedded;
import org.hibernate.jpamodelgen.xml.jaxb.EmbeddedId;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.Id;
import org.hibernate.jpamodelgen.xml.jaxb.ManyToMany;
import org.hibernate.jpamodelgen.xml.jaxb.ManyToOne;
import org.hibernate.jpamodelgen.xml.jaxb.MapKeyClass;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.OneToMany;
import org.hibernate.jpamodelgen.xml.jaxb.OneToOne;

public class XmlMetaEntity
implements MetaEntity {
    static final Map<String, String> COLLECTIONS = new HashMap<String, String>();
    private final String clazzName;
    private final String packageName;
    private final String defaultPackageName;
    private final ImportContext importContext;
    private final List<MetaAttribute> members = new ArrayList<MetaAttribute>();
    private final TypeElement element;
    private final Context context;
    private final boolean isMetaComplete;
    private Attributes attributes;
    private EmbeddableAttributes embeddableAttributes;
    private AccessTypeInformation accessTypeInfo;
    private boolean initialized;

    XmlMetaEntity(Entity ormEntity, String defaultPackageName, TypeElement element, Context context) {
        this(ormEntity.getClazz(), defaultPackageName, element, context, ormEntity.isMetadataComplete());
        this.attributes = ormEntity.getAttributes();
        this.embeddableAttributes = null;
        this.init();
    }

    XmlMetaEntity(MappedSuperclass mappedSuperclass, String defaultPackageName, TypeElement element, Context context) {
        this(mappedSuperclass.getClazz(), defaultPackageName, element, context, mappedSuperclass.isMetadataComplete());
        this.attributes = mappedSuperclass.getAttributes();
        this.embeddableAttributes = null;
    }

    XmlMetaEntity(Embeddable embeddable, String defaultPackageName, TypeElement element, Context context) {
        this(embeddable.getClazz(), defaultPackageName, element, context, embeddable.isMetadataComplete());
        this.attributes = null;
        this.embeddableAttributes = embeddable.getAttributes();
    }

    private XmlMetaEntity(String clazz, String defaultPackageName, TypeElement element, Context context, Boolean metaComplete) {
        this.defaultPackageName = defaultPackageName;
        String className = clazz;
        String pkg = defaultPackageName;
        if (StringUtil.isFullyQualified(className)) {
            pkg = StringUtil.packageNameFromFqcn(className);
            className = StringUtil.classNameFromFqcn(clazz);
        }
        this.clazzName = className;
        this.packageName = pkg;
        this.context = context;
        this.importContext = new ImportContextImpl(this.getPackageName());
        this.element = element;
        this.isMetaComplete = this.initIsMetaComplete(metaComplete);
    }

    private final void init() {
        this.context.logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        this.accessTypeInfo = this.context.getAccessTypeInfo(this.getQualifiedName());
        if (this.attributes != null) {
            this.parseAttributes(this.attributes);
        } else {
            this.parseEmbeddableAttributes(this.embeddableAttributes);
        }
        this.initialized = true;
    }

    @Override
    public String getSimpleName() {
        return this.clazzName;
    }

    @Override
    public String getQualifiedName() {
        return this.packageName + "." + this.getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public List<MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
        }
        return this.members;
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public TypeElement getTypeElement() {
        return this.element;
    }

    @Override
    public boolean isMetaComplete() {
        return this.isMetaComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaEntity");
        sb.append("{accessTypeInfo=").append(this.accessTypeInfo);
        sb.append(", clazzName='").append(this.clazzName).append('\'');
        sb.append(", members=").append(this.members);
        sb.append(", isMetaComplete=").append(this.isMetaComplete);
        sb.append('}');
        return sb.toString();
    }

    private boolean initIsMetaComplete(Boolean metadataComplete) {
        return this.context.isFullyXmlConfigured() || Boolean.TRUE.equals(metadataComplete);
    }

    private String[] getCollectionTypes(String propertyName, String explicitTargetEntity, String explicitMapKeyClass, ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            DeclaredType type;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String elementPropertyName = element.getSimpleName().toString();
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                elementPropertyName = StringUtil.getPropertyName(elementPropertyName);
            }
            if (!propertyName.equals(elementPropertyName) || (type = this.determineDeclaredType(element)) == null) continue;
            return this.determineTypes(propertyName, explicitTargetEntity, explicitMapKeyClass, type);
        }
        return null;
    }

    private DeclaredType determineDeclaredType(Element elem) {
        ExecutableType executableType;
        DeclaredType type = null;
        if (elem.asType() instanceof DeclaredType) {
            type = (DeclaredType)elem.asType();
        } else if (elem.asType() instanceof ExecutableType && (executableType = (ExecutableType)elem.asType()).getReturnType() instanceof DeclaredType) {
            type = (DeclaredType)executableType.getReturnType();
        }
        return type;
    }

    private String[] determineTypes(String propertyName, String explicitTargetEntity, String explicitMapKeyClass, DeclaredType type) {
        String[] types = new String[3];
        this.determineTargetType(type, propertyName, explicitTargetEntity, types);
        this.determineCollectionType(type, types);
        if (types[1].equals("javax.persistence.metamodel.MapAttribute")) {
            this.determineMapType(type, explicitMapKeyClass, types);
        }
        return types;
    }

    private void determineMapType(DeclaredType type, String explicitMapKeyClass, String[] types) {
        types[2] = explicitMapKeyClass != null ? explicitMapKeyClass : TypeUtils.getKeyType(type, this.context);
    }

    private void determineCollectionType(DeclaredType type, String[] types) {
        types[1] = COLLECTIONS.get(type.asElement().toString());
    }

    private void determineTargetType(DeclaredType type, String propertyName, String explicitTargetEntity, String[] types) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == 0 && explicitTargetEntity == null) {
            throw new MetaModelGenerationException("Unable to determine target entity type for " + this.clazzName + "." + propertyName + ".");
        }
        types[0] = explicitTargetEntity == null ? TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), this.context) : explicitTargetEntity;
    }

    private String getType(String propertyName, String explicitTargetEntity, ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            TypeMirror mirror;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String name = element.getSimpleName().toString();
            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                name = StringUtil.getPropertyName(name);
                mirror = ((ExecutableElement)element).getReturnType();
            } else {
                mirror = element.asType();
            }
            if (name == null || !name.equals(propertyName)) continue;
            if (explicitTargetEntity != null) {
                return explicitTargetEntity;
            }
            switch (mirror.getKind()) {
                case INT: {
                    return "java.lang.Integer";
                }
                case LONG: {
                    return "java.lang.Long";
                }
                case BOOLEAN: {
                    return "java.lang.Boolean";
                }
                case BYTE: {
                    return "java.lang.Byte";
                }
                case SHORT: {
                    return "java.lang.Short";
                }
                case CHAR: {
                    return "java.lang.Char";
                }
                case FLOAT: {
                    return "java.lang.Float";
                }
                case DOUBLE: {
                    return "java.lang.Double";
                }
                case DECLARED: {
                    return mirror.toString();
                }
                case TYPEVAR: {
                    return mirror.toString();
                }
            }
        }
        this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to determine type for property " + propertyName + " of class " + this.getQualifiedName() + " using access type " + (Object)((Object)this.accessTypeInfo.getDefaultAccessType()));
        return null;
    }

    private void parseAttributes(Attributes attributes) {
        ElementCollection collection;
        OneToMany oneToMany;
        ManyToMany manyToMany;
        XmlMetaSingleAttribute attribute;
        for (Id id : attributes.getId()) {
            ElementKind elementKind = this.getElementKind(id.getAccess());
            String type = this.getType(id.getName(), null, elementKind);
            if (type == null) continue;
            attribute = new XmlMetaSingleAttribute(this, id.getName(), type);
            this.members.add(attribute);
        }
        if (attributes.getEmbeddedId() != null) {
            EmbeddedId embeddedId = attributes.getEmbeddedId();
            ElementKind elementKind = this.getElementKind(embeddedId.getAccess());
            String type = this.getType(embeddedId.getName(), null, elementKind);
            if (type != null) {
                attribute = new XmlMetaSingleAttribute(this, embeddedId.getName(), type);
                this.members.add(attribute);
            }
        }
        for (Basic basic : attributes.getBasic()) {
            this.parseBasic(basic);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            this.parseManyToOne(manyToOne);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator<Object> iterator = attributes.getManyToMany().iterator();
        while (iterator.hasNext() && !this.parseManyToMany(manyToMany = (ManyToMany)iterator.next())) {
        }
        iterator = attributes.getOneToMany().iterator();
        while (iterator.hasNext() && !this.parseOneToMany(oneToMany = (OneToMany)iterator.next())) {
        }
        iterator = attributes.getElementCollection().iterator();
        while (iterator.hasNext() && !this.parseElementCollection(collection = (ElementCollection)iterator.next())) {
        }
        for (Embedded embedded : attributes.getEmbedded()) {
            this.parseEmbedded(embedded);
        }
    }

    private void parseEmbeddableAttributes(EmbeddableAttributes attributes) {
        ElementCollection collection;
        OneToMany oneToMany;
        ManyToMany manyToMany;
        if (attributes == null) {
            return;
        }
        for (Basic basic : attributes.getBasic()) {
            this.parseBasic(basic);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            this.parseManyToOne(manyToOne);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator<Object> iterator = attributes.getManyToMany().iterator();
        while (iterator.hasNext() && !this.parseManyToMany(manyToMany = (ManyToMany)iterator.next())) {
        }
        iterator = attributes.getOneToMany().iterator();
        while (iterator.hasNext() && !this.parseOneToMany(oneToMany = (OneToMany)iterator.next())) {
        }
        iterator = attributes.getElementCollection().iterator();
        while (iterator.hasNext() && !this.parseElementCollection(collection = (ElementCollection)iterator.next())) {
        }
    }

    private boolean parseElementCollection(ElementCollection collection) {
        String[] types;
        ElementKind elementKind = this.getElementKind(collection.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(collection.getTargetClass());
        String explicitMapKey = this.determineExplicitMapKeyClass(collection.getMapKeyClass());
        try {
            types = this.getCollectionTypes(collection.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(collection.getName(), e);
            return true;
        }
        if (types != null) {
            XmlMetaCollection metaCollection = types[2] == null ? new XmlMetaCollection(this, collection.getName(), types[0], types[1]) : new XmlMetaMap(this, collection.getName(), types[0], types[1], types[2]);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseEmbedded(Embedded embedded) {
        ElementKind elementKind = this.getElementKind(embedded.getAccess());
        String type = this.getType(embedded.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, embedded.getName(), type);
            this.members.add(attribute);
        }
    }

    private String determineExplicitTargetEntity(String targetClass) {
        String explicitTargetClass = targetClass;
        if (explicitTargetClass != null) {
            explicitTargetClass = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, targetClass);
        }
        return explicitTargetClass;
    }

    private String determineExplicitMapKeyClass(MapKeyClass mapKeyClass) {
        String explicitMapKey = null;
        if (mapKeyClass != null) {
            explicitMapKey = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, mapKeyClass.getClazz());
        }
        return explicitMapKey;
    }

    private boolean parseOneToMany(OneToMany oneToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(oneToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(oneToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(oneToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(oneToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(oneToMany.getName(), e);
            return true;
        }
        if (types != null) {
            XmlMetaCollection metaCollection = types[2] == null ? new XmlMetaCollection(this, oneToMany.getName(), types[0], types[1]) : new XmlMetaMap(this, oneToMany.getName(), types[0], types[1], types[2]);
            this.members.add(metaCollection);
        }
        return false;
    }

    private boolean parseManyToMany(ManyToMany manyToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(manyToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(manyToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(manyToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(manyToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(manyToMany.getName(), e);
            return true;
        }
        if (types != null) {
            XmlMetaCollection metaCollection = types[2] == null ? new XmlMetaCollection(this, manyToMany.getName(), types[0], types[1]) : new XmlMetaMap(this, manyToMany.getName(), types[0], types[1], types[2]);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseOneToOne(OneToOne oneToOne) {
        ElementKind elementKind = this.getElementKind(oneToOne.getAccess());
        String type = this.getType(oneToOne.getName(), oneToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, oneToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseManyToOne(ManyToOne manyToOne) {
        ElementKind elementKind = this.getElementKind(manyToOne.getAccess());
        String type = this.getType(manyToOne.getName(), manyToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, manyToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseBasic(Basic basic) {
        ElementKind elementKind = this.getElementKind(basic.getAccess());
        String type = this.getType(basic.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, basic.getName(), type);
            this.members.add(attribute);
        }
    }

    private void logMetaModelException(String name, MetaModelGenerationException e) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error processing xml for ");
        builder.append(this.clazzName);
        builder.append(".");
        builder.append(name);
        builder.append(". Error message: ");
        builder.append(e.getMessage());
        this.context.logMessage(Diagnostic.Kind.WARNING, builder.toString());
    }

    private ElementKind getElementKind(AccessType accessType) {
        if (accessType == null) {
            return TypeUtils.getElementKindForAccessType(this.accessTypeInfo.getAccessType());
        }
        if (AccessType.FIELD.equals((Object)accessType)) {
            return ElementKind.FIELD;
        }
        return ElementKind.METHOD;
    }

    static {
        COLLECTIONS.put("java.util.Collection", "javax.persistence.metamodel.CollectionAttribute");
        COLLECTIONS.put("java.util.Set", "javax.persistence.metamodel.SetAttribute");
        COLLECTIONS.put("java.util.List", "javax.persistence.metamodel.ListAttribute");
        COLLECTIONS.put("java.util.Map", "javax.persistence.metamodel.MapAttribute");
    }
}

