/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.jpamodelgen.model.ImportContext;

public class ImportContextImpl
implements ImportContext {
    private Set<String> imports = new TreeSet<String>();
    private Set<String> staticImports = new TreeSet<String>();
    private Map<String, String> simpleNames = new HashMap<String, String>();
    private String basePackage = "";
    private static final Map<String, String> PRIMITIVES = new HashMap<String, String>();

    public ImportContextImpl(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public String importType(String fqcn) {
        boolean canBeSimple;
        String result = fqcn;
        String additionalTypePart = null;
        if (fqcn.indexOf(60) >= 0) {
            additionalTypePart = result.substring(fqcn.indexOf(60));
            fqcn = result = result.substring(0, fqcn.indexOf(60));
        } else if (fqcn.indexOf(91) >= 0) {
            additionalTypePart = result.substring(fqcn.indexOf(91));
            fqcn = result = result.substring(0, fqcn.indexOf(91));
        }
        String pureFqcn = fqcn.replace('$', '.');
        String simpleName = ImportContextImpl.unqualify(fqcn);
        if (this.simpleNames.containsKey(simpleName)) {
            String existingFqcn = this.simpleNames.get(simpleName);
            canBeSimple = existingFqcn.equals(pureFqcn);
        } else {
            canBeSimple = true;
            this.simpleNames.put(simpleName, pureFqcn);
            this.imports.add(pureFqcn);
        }
        if (this.inSamePackage(fqcn) || this.imports.contains(pureFqcn) && canBeSimple) {
            result = ImportContextImpl.unqualify(result);
        } else if (this.inJavaLang(fqcn)) {
            result = result.substring("java.lang.".length());
        }
        if (additionalTypePart != null) {
            result = result + additionalTypePart;
        }
        result = result.replace('$', '.');
        return result;
    }

    @Override
    public String staticImport(String fqcn, String member) {
        String local = fqcn + "." + member;
        this.imports.add(local);
        this.staticImports.add(local);
        if (member.equals("*")) {
            return "";
        }
        return member;
    }

    private boolean inDefaultPackage(String className) {
        return className.indexOf(".") < 0;
    }

    private boolean isPrimitive(String className) {
        return PRIMITIVES.containsKey(className);
    }

    private boolean inSamePackage(String className) {
        String other = ImportContextImpl.qualifier(className);
        return other == this.basePackage || other != null && other.equals(this.basePackage);
    }

    private boolean inJavaLang(String className) {
        return "java.lang".equals(ImportContextImpl.qualifier(className));
    }

    @Override
    public String generateImports() {
        StringBuilder builder = new StringBuilder();
        for (String next : this.imports) {
            if (this.isAutoImported(next)) continue;
            if (this.staticImports.contains(next)) {
                builder.append("import static ").append(next).append(";").append(System.lineSeparator());
                continue;
            }
            builder.append("import ").append(next).append(";").append(System.lineSeparator());
        }
        if (builder.indexOf("$") >= 0) {
            return builder.toString();
        }
        return builder.toString();
    }

    private boolean isAutoImported(String next) {
        return this.isPrimitive(next) || this.inDefaultPackage(next) || this.inJavaLang(next) || this.inSamePackage(next);
    }

    public static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    public static String qualifier(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? "" : qualifiedName.substring(0, loc);
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

