/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.DirectoryProviderHelper;
import org.hibernate.search.util.FileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSlaveDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static Log log = LogFactory.getLog(FSSlaveDirectoryProvider.class);
    private FSDirectory directory1;
    private FSDirectory directory2;
    private int current;
    private String indexName;
    private Timer timer;
    private String source;
    private File indexDir;
    private String directoryProviderName;
    private Properties properties;

    @Override
    public void initialize(String directoryProviderName, Properties properties, SearchFactoryImplementor searchFactoryImplementor) {
        this.properties = properties;
        this.directoryProviderName = directoryProviderName;
        this.source = DirectoryProviderHelper.getSourceDirectory("sourceBase", "source", directoryProviderName, properties);
        if (this.source == null) {
            throw new IllegalStateException("FSSlaveDirectoryProvider requires a viable source directory");
        }
        if (!new File(this.source, "current1").exists() && !new File(this.source, "current2").exists()) {
            throw new IllegalStateException("No current marker in source directory");
        }
        log.debug((Object)("Source directory: " + this.source));
        this.indexDir = DirectoryProviderHelper.determineIndexDir(directoryProviderName, properties);
        log.debug((Object)("Index directory: " + this.indexDir.getPath()));
        try {
            boolean create;
            boolean bl = create = !this.indexDir.exists();
            if (create) {
                log.debug((Object)("index directory not found, creating: '" + this.indexDir.getAbsolutePath() + "'"));
                this.indexDir.mkdirs();
            }
            this.indexName = this.indexDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new HibernateException("Unable to initialize index: " + directoryProviderName, (Throwable)e);
        }
    }

    @Override
    public void start() {
        String refreshPeriod = this.properties.getProperty("refresh", "3600");
        long period = Long.parseLong(refreshPeriod);
        log.debug((Object)("Refresh period " + period + " seconds"));
        period *= 1000L;
        try {
            IndexWriter iw;
            File subDir = new File(this.indexName, "1");
            boolean create = !subDir.exists();
            this.directory1 = FSDirectory.getDirectory((String)subDir.getCanonicalPath());
            if (create) {
                log.debug((Object)("Initialize index: '" + subDir.getAbsolutePath() + "'"));
                iw = new IndexWriter((Directory)this.directory1, (Analyzer)new StandardAnalyzer(), create);
                iw.close();
            }
            create = !(subDir = new File(this.indexName, "2")).exists();
            this.directory2 = FSDirectory.getDirectory((String)subDir.getCanonicalPath());
            if (create) {
                log.debug((Object)("Initialize index: '" + subDir.getAbsolutePath() + "'"));
                iw = new IndexWriter((Directory)this.directory2, (Analyzer)new StandardAnalyzer(), create);
                iw.close();
            }
            File currentMarker = new File(this.indexName, "current1");
            File current2Marker = new File(this.indexName, "current2");
            if (currentMarker.exists()) {
                this.current = 1;
            } else if (current2Marker.exists()) {
                this.current = 2;
            } else {
                int sourceCurrent;
                log.debug((Object)"Setting directory 1 as current");
                this.current = 1;
                File sourceFile = new File(this.source);
                File destinationFile = new File(this.indexName, Integer.valueOf(this.current).toString());
                if (new File(sourceFile, "current1").exists()) {
                    sourceCurrent = 1;
                } else if (new File(sourceFile, "current2").exists()) {
                    sourceCurrent = 2;
                } else {
                    throw new AssertionFailure("No current file marker found in source directory: " + this.source);
                }
                try {
                    FileHelper.synchronize(new File(sourceFile, String.valueOf(sourceCurrent)), destinationFile, true);
                }
                catch (IOException e) {
                    throw new HibernateException("Umable to synchonize directory: " + this.indexName, (Throwable)e);
                }
                if (!currentMarker.createNewFile()) {
                    throw new HibernateException("Unable to create the directory marker file: " + this.indexName);
                }
            }
            log.debug((Object)("Current directory: " + this.current));
        }
        catch (IOException e) {
            throw new HibernateException("Unable to initialize index: " + this.directoryProviderName, (Throwable)e);
        }
        this.timer = new Timer(true);
        TriggerTask task = new TriggerTask(this.source, this.indexName);
        this.timer.scheduleAtFixedRate((TimerTask)task, period, period);
    }

    @Override
    public FSDirectory getDirectory() {
        if (this.current == 1) {
            return this.directory1;
        }
        if (this.current == 2) {
            return this.directory2;
        }
        throw new AssertionFailure("Illegal current directory: " + this.current);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSSlaveDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSSlaveDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.timer.cancel();
    }

    class CopyDirectory
    implements Runnable {
        private String source;
        private String destination;
        private volatile boolean inProgress;

        public CopyDirectory(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            try {
                File sourceFile;
                int index;
                this.inProgress = true;
                int oldIndex = FSSlaveDirectoryProvider.this.current;
                int n = index = FSSlaveDirectoryProvider.this.current == 1 ? 2 : 1;
                if (new File(this.source, "current1").exists()) {
                    sourceFile = new File(this.source, "1");
                } else if (new File(this.source, "current2").exists()) {
                    sourceFile = new File(this.source, "2");
                } else {
                    log.error((Object)"Unable to determine current in source directory");
                    this.inProgress = false;
                    return;
                }
                File destinationFile = new File(this.destination, Integer.valueOf(index).toString());
                try {
                    log.trace((Object)("Copying " + sourceFile + " into " + destinationFile));
                    FileHelper.synchronize(sourceFile, destinationFile, true);
                    FSSlaveDirectoryProvider.this.current = index;
                }
                catch (IOException e) {
                    log.error((Object)("Unable to synchronize " + FSSlaveDirectoryProvider.this.indexName), (Throwable)e);
                    this.inProgress = false;
                    this.inProgress = false;
                    return;
                }
                if (!new File(FSSlaveDirectoryProvider.this.indexName, "current" + oldIndex).delete()) {
                    log.warn((Object)("Unable to remove previous marker file in " + FSSlaveDirectoryProvider.this.indexName));
                }
                try {
                    new File(FSSlaveDirectoryProvider.this.indexName, "current" + index).createNewFile();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to create current marker file in " + FSSlaveDirectoryProvider.this.indexName), (Throwable)e);
                }
            }
            finally {
                this.inProgress = false;
            }
            log.trace((Object)("Copy for " + FSSlaveDirectoryProvider.this.indexName + " took " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    class TriggerTask
    extends TimerTask {
        private ExecutorService executor = Executors.newSingleThreadExecutor();
        private CopyDirectory copyTask;

        public TriggerTask(String source, String destination) {
            this.copyTask = new CopyDirectory(source, destination);
        }

        public void run() {
            if (!this.copyTask.inProgress) {
                this.executor.execute(this.copyTask);
            } else {
                log.trace((Object)("Skipping directory synchronization, previous work still in progress: " + FSSlaveDirectoryProvider.this.indexName));
            }
        }
    }
}

