/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSearchResourceLoader
implements ResourceLoader {
    public InputStream openResource(String resource) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLines(String resource) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.openResource(resource)));
            ArrayList<String> results = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                if (line.length() != 0 && !line.startsWith("#")) {
                    results.add(line);
                }
                line = reader.readLine();
            }
            List<String> list = Collections.unmodifiableList(results);
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Object newInstance(String cname, String ... subpackages) {
        Class clazz;
        if (subpackages != null && subpackages.length > 0) {
            throw new UnsupportedOperationException("newInstance(classname, packages) not implemented");
        }
        try {
            clazz = ReflectHelper.classForName((String)cname);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to find class " + cname, e);
        }
        try {
            Object instance = clazz.newInstance();
            if (instance instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)instance).inform((ResourceLoader)this);
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instanciate class with no-arg constructor: " + cname, e);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instanciate class with no-arg constructor: " + cname, e);
        }
    }
}

