/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.FuzzyContext;
import org.hibernate.search.query.dsl.TermContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.WildcardContext;
import org.hibernate.search.query.dsl.impl.ConnectedFuzzyContext;
import org.hibernate.search.query.dsl.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedWildcardContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

class ConnectedTermContext
implements TermContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;

    public ConnectedTermContext(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = new QueryCustomizer();
        this.termContext = new TermQueryContext(TermQueryContext.Approximation.EXACT);
    }

    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.termContext, field, this.queryCustomizer, this.queryContext);
    }

    public TermMatchingContext onFields(String ... fields) {
        return new ConnectedTermMatchingContext(this.termContext, fields, this.queryCustomizer, this.queryContext);
    }

    public FuzzyContext fuzzy() {
        return new ConnectedFuzzyContext(this.queryCustomizer, this.queryContext);
    }

    public WildcardContext wildcard() {
        return new ConnectedWildcardContext(this.queryCustomizer, this.queryContext);
    }

    public ConnectedTermContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public ConnectedTermContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    public ConnectedTermContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

