/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.io.Serializable;
import java.util.List;
import org.geolatte.geom.codec.db.oracle.ConnectionFinder;
import org.geolatte.geom.codec.db.oracle.DefaultConnectionFinder;
import org.geolatte.geom.codec.db.oracle.OracleJDBCTypeFactory;
import org.hibernate.QueryException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.HibernateSpatialConfiguration;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.oracle.GetDimensionFunction;
import org.hibernate.spatial.dialect.oracle.GetGeometryTypeFunction;
import org.hibernate.spatial.dialect.oracle.SDOBooleanType;
import org.hibernate.spatial.dialect.oracle.SDOGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.oracle.SDOObjectProperty;
import org.hibernate.spatial.dialect.oracle.SpatialAggregate;
import org.hibernate.spatial.dialect.oracle.WrappedOGCFunction;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class OracleSpatial10gDialect
extends Oracle10gDialect
implements SpatialDialect,
Serializable {
    private final boolean isOgcStrict;
    private final ConnectionFinder connectionFinder;

    public OracleSpatial10gDialect() {
        this(new HibernateSpatialConfiguration());
    }

    public OracleSpatial10gDialect(HibernateSpatialConfiguration config) {
        this.isOgcStrict = config.isOgcStrictMode();
        ConnectionFinder finder = config.getConnectionFinder();
        this.connectionFinder = finder == null ? new DefaultConnectionFinder() : finder;
        this.registerColumnType(2002, "MDSYS.SDO_GEOMETRY");
        this.registerFunction("dimension", new GetDimensionFunction());
        this.registerFunction("geometrytype", new GetGeometryTypeFunction());
        this.registerFunction("srid", new SDOObjectProperty("SDO_SRID", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("SDO_GEOM.SDO_MBR"));
        this.registerFunction("astext", (SQLFunction)new AsTextFunction());
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("SDO_UTIL.TO_WKBGEOMETRY", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new WrappedOGCFunction("OGC_ISEMPTY", (Type)StandardBasicTypes.BOOLEAN, new boolean[]{true}));
        this.registerFunction("issimple", (SQLFunction)new WrappedOGCFunction("OGC_ISSIMPLE", (Type)StandardBasicTypes.BOOLEAN, new boolean[]{true}));
        this.registerFunction("boundary", (SQLFunction)new WrappedOGCFunction("OGC_BOUNDARY", new boolean[]{true}));
        this.registerFunction("overlaps", (SQLFunction)new SpatialRelateFunction("overlaps", 5));
        this.registerFunction("intersects", (SQLFunction)new SpatialRelateFunction("intersects", 7));
        this.registerFunction("contains", (SQLFunction)new SpatialRelateFunction("contains", 6));
        this.registerFunction("crosses", (SQLFunction)new SpatialRelateFunction("crosses", 3));
        this.registerFunction("disjoint", (SQLFunction)new SpatialRelateFunction("disjoint", 1));
        this.registerFunction("equals", (SQLFunction)new SpatialRelateFunction("equals", 0));
        this.registerFunction("touches", (SQLFunction)new SpatialRelateFunction("touches", 2));
        this.registerFunction("within", (SQLFunction)new SpatialRelateFunction("within", 4));
        this.registerFunction("relate", (SQLFunction)new WrappedOGCFunction("OGC_RELATE", (Type)StandardBasicTypes.BOOLEAN, new boolean[]{true, true, false}));
        this.registerFunction("distance", (SQLFunction)new SpatialAnalysisFunction("distance", (Type)StandardBasicTypes.DOUBLE, 1));
        this.registerFunction("buffer", (SQLFunction)new SpatialAnalysisFunction("buffer", 2));
        this.registerFunction("convexhull", (SQLFunction)new SpatialAnalysisFunction("convexhull", 3));
        this.registerFunction("difference", (SQLFunction)new SpatialAnalysisFunction("difference", 6));
        this.registerFunction("intersection", (SQLFunction)new SpatialAnalysisFunction("intersection", 4));
        this.registerFunction("symdifference", (SQLFunction)new SpatialAnalysisFunction("symdifference", 7));
        this.registerFunction("geomunion", (SQLFunction)new SpatialAnalysisFunction("union", 5));
        this.registerFunction("extent", (SQLFunction)new SpatialAggregationFunction("extent", false, 1));
        this.registerFunction("transform", (SQLFunction)new StandardSQLFunction("SDO_CS.TRANSFORM"));
        this.registerFunction("centroid", (SQLFunction)new SpatialAggregationFunction("extent", false, 101));
        this.registerFunction("concat_lines", (SQLFunction)new SpatialAggregationFunction("extent", false, 102));
        this.registerFunction("aggr_convexhull", (SQLFunction)new SpatialAggregationFunction("extent", false, 104));
        this.registerFunction("aggr_union", (SQLFunction)new SpatialAggregationFunction("extent", false, 103));
        this.registerFunction("lrs_concat", (SQLFunction)new SpatialAggregationFunction("lrsconcat", false, 100));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        SDOGeometryTypeDescriptor sdoGeometryTypeDescriptor = new SDOGeometryTypeDescriptor(new OracleJDBCTypeFactory(this.connectionFinder));
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(sdoGeometryTypeDescriptor));
        typeContributions.contributeType((BasicType)new JTSGeometryType(sdoGeometryTypeDescriptor));
    }

    String getNativeSpatialRelateSQL(String arg1, String arg2, int spatialRelation) {
        String mask = "";
        boolean negate = false;
        switch (spatialRelation) {
            case 7: {
                mask = "ANYINTERACT";
                break;
            }
            case 6: {
                mask = "CONTAINS+COVERS";
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Oracle Spatial does't have equivalent CROSSES relationship");
            }
            case 1: {
                mask = "ANYINTERACT";
                negate = true;
                break;
            }
            case 0: {
                mask = "EQUAL";
                break;
            }
            case 5: {
                mask = "OVERLAPBDYDISJOINT+OVERLAPBDYINTERSECT";
                break;
            }
            case 2: {
                mask = "TOUCH";
                break;
            }
            case 4: {
                mask = "INSIDE+COVEREDBY";
                break;
            }
            default: {
                throw new IllegalArgumentException("undefined SpatialRelation passed (" + spatialRelation + ")");
            }
        }
        StringBuffer buffer = new StringBuffer("CASE SDO_RELATE(").append(arg1).append(",").append(arg2).append(",'mask=" + mask + "') ");
        if (!negate) {
            buffer.append(" WHEN 'TRUE' THEN 1 ELSE 0 END");
        } else {
            buffer.append(" WHEN 'TRUE' THEN 0 ELSE 1 END");
        }
        return buffer.toString();
    }

    String getOGCSpatialRelateSQL(String arg1, String arg2, int spatialRelation) {
        StringBuffer ogcFunction = new StringBuffer("MDSYS.");
        switch (spatialRelation) {
            case 7: {
                ogcFunction.append("OGC_INTERSECTS");
                break;
            }
            case 6: {
                ogcFunction.append("OGC_CONTAINS");
                break;
            }
            case 3: {
                ogcFunction.append("OGC_CROSS");
                break;
            }
            case 1: {
                ogcFunction.append("OGC_DISJOINT");
                break;
            }
            case 0: {
                ogcFunction.append("OGC_EQUALS");
                break;
            }
            case 5: {
                ogcFunction.append("OGC_OVERLAP");
                break;
            }
            case 2: {
                ogcFunction.append("OGC_TOUCH");
                break;
            }
            case 4: {
                ogcFunction.append("OGC_WITHIN");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SpatialRelation (" + spatialRelation + ").");
            }
        }
        ogcFunction.append("(").append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(arg1).append("),").append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(arg2).append(")").append(")");
        return ogcFunction.toString();
    }

    String getNativeSpatialAggregateSQL(String arg1, int aggregation) {
        StringBuffer aggregateFunction = new StringBuffer();
        SpatialAggregate sa = new SpatialAggregate(aggregation);
        if (sa.getAggregateSyntax() == null) {
            throw new IllegalArgumentException("Unknown Spatial Aggregation (" + aggregation + ").");
        }
        aggregateFunction.append(sa.getAggregateSyntax());
        aggregateFunction.append("(");
        if (sa.isAggregateType()) {
            aggregateFunction.append("SDOAGGRTYPE(");
        }
        aggregateFunction.append(arg1);
        if (sa.isAggregateType()) {
            aggregateFunction.append(", ").append(0.001).append(")");
        }
        aggregateFunction.append(")");
        return aggregateFunction.toString();
    }

    private StringBuffer wrapInSTGeometry(String geomColumn, StringBuffer toAdd) {
        return toAdd.append("MDSYS.ST_GEOMETRY(").append(geomColumn).append(")");
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        StringBuffer buffer = new StringBuffer("SDO_FILTER(");
        buffer.append(columnName);
        buffer.append(",?) = 'TRUE' ");
        return buffer.toString();
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        String sql = (this.isOGCStrict() ? this.getOGCSpatialRelateSQL(columnName, "?", spatialRelation) : this.getNativeSpatialRelateSQL(columnName, "?", spatialRelation)) + " = 1";
        sql = sql + " and " + columnName + " is not null";
        return sql;
    }

    String getSpatialAnalysisSQL(List args, int spatialAnalysisFunction, boolean useFilter) {
        return this.isOGCStrict() ? this.getOGCSpatialAnalysisSQL(args, spatialAnalysisFunction) : this.getNativeSpatialAnalysisSQL(args, spatialAnalysisFunction);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int spatialAggregateFunction) {
        return this.getNativeSpatialAggregateSQL(columnName, spatialAggregateFunction);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "SDO_WITHIN_DISTANCE (" + columnName + ",?, ?) = 'TRUE' ";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return String.format(" (MDSYS.ST_GEOMETRY(%s).ST_SRID() = ?)", columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return String.format("( MDSYS.ST_GEOMETRY(%s).ST_ISEMPTY() = %d )", columnName, isEmpty ? 1 : 0);
    }

    private String getOGCSpatialAnalysisSQL(List args, int spatialAnalysisFunction) {
        boolean[] geomArgs;
        StringBuffer ogcFunction = new StringBuffer("MDSYS.");
        boolean isGeomReturn = true;
        switch (spatialAnalysisFunction) {
            case 2: {
                ogcFunction.append("OGC_BUFFER");
                geomArgs = new boolean[]{true, false};
                break;
            }
            case 3: {
                ogcFunction.append("OGC_CONVEXHULL");
                geomArgs = new boolean[]{true};
                break;
            }
            case 6: {
                ogcFunction.append("OGC_DIFFERENCE");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 1: {
                ogcFunction.append("OGC_DISTANCE");
                geomArgs = new boolean[]{true, true};
                isGeomReturn = false;
                break;
            }
            case 4: {
                ogcFunction.append("OGC_INTERSECTION");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 7: {
                ogcFunction.append("OGC_SYMMETRICDIFFERENCE");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 5: {
                ogcFunction.append("OGC_UNION");
                geomArgs = new boolean[]{true, true};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SpatialAnalysisFunction (" + spatialAnalysisFunction + ").");
            }
        }
        if (args.size() < geomArgs.length) {
            throw new QueryException("Insufficient arguments for spatial analysis function (function type:  " + spatialAnalysisFunction + ").");
        }
        ogcFunction.append("(");
        for (int i = 0; i < geomArgs.length; ++i) {
            if (i > 0) {
                ogcFunction.append(",");
            }
            if (geomArgs[i]) {
                this.wrapInSTGeometry((String)args.get(i), ogcFunction);
                continue;
            }
            ogcFunction.append(args.get(i));
        }
        ogcFunction.append(")");
        if (isGeomReturn) {
            ogcFunction.append(".geom");
        }
        return ogcFunction.toString();
    }

    private String getNativeSpatialAnalysisSQL(List args, int spatialAnalysis) {
        return this.getOGCSpatialAnalysisSQL(args, spatialAnalysis);
    }

    public boolean isOGCStrict() {
        return this.isOgcStrict;
    }

    public ConnectionFinder getConnectionFinder() {
        return this.connectionFinder;
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }

    private class SpatialAggregationFunction
    extends StandardSQLFunction {
        private final int aggregation;

        private SpatialAggregationFunction(String name, boolean isProjection, int aggregation) {
            super(name);
            this.aggregation = aggregation;
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            return OracleSpatial10gDialect.this.getNativeSpatialAggregateSQL((String)args.get(0), this.aggregation);
        }
    }

    private class SpatialAnalysisFunction
    extends StandardSQLFunction {
        private final int analysis;

        private SpatialAnalysisFunction(String name, Type returnType, int analysis) {
            super(name, returnType);
            this.analysis = analysis;
        }

        private SpatialAnalysisFunction(String name, int analysis) {
            this(name, null, analysis);
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            return OracleSpatial10gDialect.this.isOGCStrict() ? OracleSpatial10gDialect.this.getSpatialAnalysisSQL(args, this.analysis, false) : OracleSpatial10gDialect.this.getNativeSpatialAnalysisSQL(args, this.analysis);
        }
    }

    private class SpatialRelateFunction
    extends StandardSQLFunction {
        private final int relation;

        private SpatialRelateFunction(String name, int relation) {
            super(name, (Type)(OracleSpatial10gDialect.this.isOGCStrict() ? StandardBasicTypes.BOOLEAN : new SDOBooleanType()));
            this.relation = relation;
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            if (args.size() < 2) {
                throw new QueryException("Spatial relate functions require at least two arguments");
            }
            return OracleSpatial10gDialect.this.isOGCStrict() ? OracleSpatial10gDialect.this.getOGCSpatialRelateSQL((String)args.get(0), (String)args.get(1), this.relation) : OracleSpatial10gDialect.this.getNativeSpatialRelateSQL((String)args.get(0), (String)args.get(1), this.relation);
        }
    }

    private static class AsTextFunction
    extends StandardSQLFunction {
        private AsTextFunction() {
            super("astext", (Type)StandardBasicTypes.STRING);
        }

        public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
            StringBuffer buf = new StringBuffer();
            if (args.isEmpty()) {
                throw new IllegalArgumentException("First Argument in arglist must be object to which method is applied");
            }
            buf.append("TO_CHAR(SDO_UTIL.TO_WKTGEOMETRY(").append(args.get(0)).append("))");
            return buf.toString();
        }
    }
}

