/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.hana;

import java.util.List;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class HANASpatialFunction
extends StandardSQLFunction {
    private static final String AS_EWKB_SUFFIX = ".ST_AsEWKB()";
    private final boolean firstArgumentIsGeometryType;

    public HANASpatialFunction(String name, boolean firstArgumentIsGeometryType) {
        super(name);
        this.firstArgumentIsGeometryType = firstArgumentIsGeometryType;
    }

    public HANASpatialFunction(String name, Type registeredType, boolean firstArgumentIsGeometryType) {
        super(name, registeredType);
        this.firstArgumentIsGeometryType = firstArgumentIsGeometryType;
    }

    public String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
        if (arguments.size() == 0) {
            return this.getName() + "()";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.stripEWKBSuffix(arguments.get(0)));
        buf.append(".").append(this.getName()).append('(');
        for (int i = 1; i < arguments.size(); ++i) {
            boolean parseFromWKB;
            Object argument = arguments.get(i);
            boolean bl = parseFromWKB = this.firstArgumentIsGeometryType && i == 1 && "?".equals(argument);
            if (parseFromWKB) {
                buf.append("ST_GeomFromEWKB(");
            }
            buf.append(this.stripEWKBSuffix(argument));
            if (parseFromWKB) {
                buf.append(")");
            }
            if (i >= arguments.size() - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        if (this.getType() == null) {
            buf.append(AS_EWKB_SUFFIX);
        }
        return buf.toString();
    }

    private Object stripEWKBSuffix(Object argument) {
        if (argument instanceof String && ((String)argument).endsWith(AS_EWKB_SUFFIX)) {
            String argumentString = (String)argument;
            return argumentString.substring(0, argumentString.length() - AS_EWKB_SUFFIX.length());
        }
        return argument;
    }
}

