/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criterion;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.criterion.Criterion;
import org.hibernate.spatial.criterion.DWithinExpression;
import org.hibernate.spatial.criterion.HavingSridExpression;
import org.hibernate.spatial.criterion.IsEmptyExpression;
import org.hibernate.spatial.criterion.SpatialFilter;
import org.hibernate.spatial.criterion.SpatialRelateExpression;

public class SpatialRestrictions {
    private SpatialRestrictions() {
    }

    public static SpatialRelateExpression eq(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 0);
    }

    public static SpatialRelateExpression within(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 4);
    }

    public static SpatialRelateExpression contains(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 6);
    }

    public static SpatialRelateExpression crosses(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 3);
    }

    public static SpatialRelateExpression disjoint(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 1);
    }

    public static SpatialRelateExpression intersects(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 7);
    }

    public static SpatialRelateExpression overlaps(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 5);
    }

    public static SpatialRelateExpression touches(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, 2);
    }

    public static SpatialFilter filter(String propertyName, Geometry value) {
        return new SpatialFilter(propertyName, value);
    }

    public static SpatialFilter filter(String propertyName, Envelope envelope, int srid) {
        return new SpatialFilter(propertyName, envelope, srid);
    }

    public static Criterion distanceWithin(String propertyName, Geometry geometry, double distance) {
        return new DWithinExpression(propertyName, geometry, distance);
    }

    public static Criterion havingSRID(String propertyName, int srid) {
        return new HavingSridExpression(propertyName, srid);
    }

    public static Criterion isEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, true);
    }

    public static Criterion isNotEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, false);
    }

    public static Criterion spatialRestriction(int relation, String propertyName, Geometry value) {
        switch (relation) {
            case 6: {
                return SpatialRestrictions.contains(propertyName, value);
            }
            case 3: {
                return SpatialRestrictions.crosses(propertyName, value);
            }
            case 1: {
                return SpatialRestrictions.disjoint(propertyName, value);
            }
            case 7: {
                return SpatialRestrictions.intersects(propertyName, value);
            }
            case 0: {
                return SpatialRestrictions.eq(propertyName, value);
            }
            case 8: {
                return SpatialRestrictions.filter(propertyName, value);
            }
            case 5: {
                return SpatialRestrictions.overlaps(propertyName, value);
            }
            case 2: {
                return SpatialRestrictions.touches(propertyName, value);
            }
            case 4: {
                return SpatialRestrictions.within(propertyName, value);
            }
        }
        throw new IllegalArgumentException("Non-existant spatial relation passed.");
    }
}

