/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.io.Serializable;
import java.util.Locale;
import org.geolatte.geom.codec.db.oracle.ConnectionFinder;
import org.geolatte.geom.codec.db.oracle.OracleJDBCTypeFactory;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.SpatialFunctionsRegistry;
import org.hibernate.spatial.dialect.WithCustomJPAFilter;
import org.hibernate.spatial.dialect.oracle.OracleSpatial10gDialect;
import org.hibernate.spatial.dialect.oracle.OracleSpatialFunctions;
import org.hibernate.spatial.dialect.oracle.SDOGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.oracle.SpatialAggregate;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.jboss.logging.Logger;

class OracleSDOSupport
implements SpatialDialect,
Serializable,
WithCustomJPAFilter {
    private static final HSMessageLogger log = (HSMessageLogger)Logger.getMessageLogger(HSMessageLogger.class, (String)OracleSpatial10gDialect.class.getName());
    private final SpatialFunctionsRegistry sdoFunctions;

    OracleSDOSupport(boolean isOgcStrict) {
        this.sdoFunctions = new OracleSpatialFunctions(isOgcStrict, this);
    }

    SpatialFunctionsRegistry functionsToRegister() {
        return this.sdoFunctions;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        SDOGeometryTypeDescriptor sdoGeometryTypeDescriptor = this.mkSdoGeometryTypeDescriptor(serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(sdoGeometryTypeDescriptor));
        typeContributions.contributeType((BasicType)new JTSGeometryType(sdoGeometryTypeDescriptor));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    private SDOGeometryTypeDescriptor mkSdoGeometryTypeDescriptor(ServiceRegistry serviceRegistry) {
        ConfigurationService cfgService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        StrategySelector strategySelector = (StrategySelector)serviceRegistry.getService(StrategySelector.class);
        ConnectionFinder connectionFinder = (ConnectionFinder)strategySelector.resolveStrategy(ConnectionFinder.class, cfgService.getSetting("hibernate.spatial.connection_finder", String.class, (Object)"org.geolatte.geom.codec.db.oracle.DefaultConnectionFinder"));
        log.connectionFinder(connectionFinder.getClass().getCanonicalName());
        return new SDOGeometryTypeDescriptor(new OracleJDBCTypeFactory(connectionFinder));
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        String sql = this.getOGCSpatialRelateSQL(columnName, "?", spatialRelation) + " = 1";
        sql = sql + " and " + columnName + " is not null";
        return sql;
    }

    public String getOGCSpatialRelateSQL(String arg1, String arg2, int spatialRelation) {
        StringBuilder ogcFunction = new StringBuilder("MDSYS.");
        switch (spatialRelation) {
            case 7: {
                ogcFunction.append("OGC_INTERSECTS");
                break;
            }
            case 6: {
                ogcFunction.append("OGC_CONTAINS");
                break;
            }
            case 3: {
                ogcFunction.append("OGC_CROSS");
                break;
            }
            case 1: {
                ogcFunction.append("OGC_DISJOINT");
                break;
            }
            case 0: {
                ogcFunction.append("OGC_EQUALS");
                break;
            }
            case 5: {
                ogcFunction.append("OGC_OVERLAP");
                break;
            }
            case 2: {
                ogcFunction.append("OGC_TOUCH");
                break;
            }
            case 4: {
                ogcFunction.append("OGC_WITHIN");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SpatialRelation (" + spatialRelation + ").");
            }
        }
        ogcFunction.append("(").append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(arg1).append("),").append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(arg2).append(")").append(")");
        return ogcFunction.toString();
    }

    public String getSDOSpatialRelateSQL(String columnName, int spatialRelation) {
        String sql = this.getNativeSpatialRelateSQL(columnName, "?", spatialRelation) + " = 1";
        sql = sql + " and " + columnName + " is not null";
        return sql;
    }

    String getNativeSpatialRelateSQL(String arg1, String arg2, int spatialRelation) {
        String mask;
        boolean negate = false;
        switch (spatialRelation) {
            case 7: {
                mask = "ANYINTERACT";
                break;
            }
            case 6: {
                mask = "CONTAINS+COVERS";
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Oracle Spatial does't have equivalent CROSSES relationship");
            }
            case 1: {
                mask = "ANYINTERACT";
                negate = true;
                break;
            }
            case 0: {
                mask = "EQUAL";
                break;
            }
            case 5: {
                mask = "OVERLAPBDYDISJOINT+OVERLAPBDYINTERSECT";
                break;
            }
            case 2: {
                mask = "TOUCH";
                break;
            }
            case 4: {
                mask = "INSIDE+COVEREDBY";
                break;
            }
            default: {
                throw new IllegalArgumentException("undefined SpatialRelation passed (" + spatialRelation + ")");
            }
        }
        StringBuilder buffer = new StringBuilder("CASE SDO_RELATE(").append(arg1).append(",").append(arg2).append(",'mask=").append(mask).append("') ");
        if (!negate) {
            buffer.append(" WHEN 'TRUE' THEN 1 ELSE 0 END");
        } else {
            buffer.append(" WHEN 'TRUE' THEN 0 ELSE 1 END");
        }
        return buffer.toString();
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        StringBuilder buffer = new StringBuilder("SDO_FILTER(");
        buffer.append(columnName);
        buffer.append(",?) = 'TRUE' ");
        return buffer.toString();
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        StringBuilder aggregateFunction = new StringBuilder();
        SpatialAggregate sa = new SpatialAggregate(aggregation);
        if (sa.getAggregateSyntax() == null) {
            throw new IllegalArgumentException("Unknown Spatial Aggregation (" + aggregation + ").");
        }
        aggregateFunction.append(sa.getAggregateSyntax());
        aggregateFunction.append("(");
        if (sa.isAggregateType()) {
            aggregateFunction.append("SDOAGGRTYPE(");
        }
        aggregateFunction.append(columnName);
        if (sa.isAggregateType()) {
            aggregateFunction.append(", ").append(0.001).append(")");
        }
        aggregateFunction.append(")");
        return aggregateFunction.toString();
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "SDO_WITHIN_DISTANCE (" + columnName + ",?, ?) = 'TRUE' ";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return String.format(Locale.ENGLISH, " (MDSYS.ST_GEOMETRY(%s).ST_SRID() = ?)", columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return String.format(Locale.ENGLISH, "( MDSYS.ST_GEOMETRY(%s).ST_ISEMPTY() = %d )", columnName, isEmpty ? 1 : 0);
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return false;
    }

    @Override
    public String filterExpression(String geometryParam, String filterParam) {
        return SpatialFunction.filter.name() + "(" + geometryParam + ", " + filterParam + ") = 'TRUE' ";
    }
}

