/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.testing.cache.BaseEntityRegionAccessStrategy;
import org.hibernate.testing.cache.EntityRegionImpl;
import org.jboss.logging.Logger;

class ReadOnlyEntityRegionAccessStrategy
extends BaseEntityRegionAccessStrategy {
    private static final Logger LOG = Logger.getLogger(ReadOnlyEntityRegionAccessStrategy.class);

    ReadOnlyEntityRegionAccessStrategy(EntityRegionImpl region) {
        super(region);
    }

    @Override
    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        this.getInternalRegion().put(session, key, value);
        return true;
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        this.evict(key);
    }

    @Override
    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        LOG.info((Object)("Illegal attempt to update item cached as read-only : " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    @Override
    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        LOG.info((Object)("Illegal attempt to update item cached as read-only : " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }
}

