/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.logging.Logger;

public class JdbcProperties {
    private static final Logger log = Logger.getLogger(JdbcProperties.class);
    public static final JdbcProperties INSTANCE = new JdbcProperties();
    private final String url;
    private final String user;
    private final String password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcProperties() {
        Properties connectionProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hibernate.properties");
            try {
                connectionProperties.load(inputStream);
                this.url = connectionProperties.getProperty("hibernate.connection.url");
                this.user = connectionProperties.getProperty("hibernate.connection.username");
                this.password = connectionProperties.getProperty("hibernate.connection.password");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ignore) {
                log.error((Object)ignore.getMessage());
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

