/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.testing.cache.BaseTransactionalDataRegion;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.cache.NonstrictReadWriteCollectionRegionAccessStrategy;
import org.hibernate.testing.cache.ReadOnlyCollectionRegionAccessStrategy;
import org.hibernate.testing.cache.ReadWriteCollectionRegionAccessStrategy;
import org.hibernate.testing.cache.TransactionalCollectionRegionAccessStrategy;
import org.jboss.logging.Logger;

class CollectionRegionImpl
extends BaseTransactionalDataRegion
implements CollectionRegion {
    private static final Logger LOG = Logger.getLogger((String)CollectionRegionImpl.class.getName());
    private final SessionFactoryOptions settings;

    CollectionRegionImpl(CachingRegionFactory cachingRegionFactory, String name, CacheDataDescription metadata, SessionFactoryOptions settings) {
        super(cachingRegionFactory, name, metadata);
        this.settings = settings;
    }

    public SessionFactoryOptions getSettings() {
        return this.settings;
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        switch (accessType) {
            case READ_ONLY: {
                if (this.getCacheDataDescription().isMutable()) {
                    LOG.warnf("read-only cache configured for mutable collection [ %s ]", (Object)this.getName());
                }
                return new ReadOnlyCollectionRegionAccessStrategy(this);
            }
            case READ_WRITE: {
                return new ReadWriteCollectionRegionAccessStrategy(this);
            }
            case NONSTRICT_READ_WRITE: {
                return new NonstrictReadWriteCollectionRegionAccessStrategy(this);
            }
            case TRANSACTIONAL: {
                return new TransactionalCollectionRegionAccessStrategy(this);
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

