/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.Work;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.OnExpectedFailure;
import org.hibernate.testing.OnFailure;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.hibernate.testing.junit4.Helper;
import org.hibernate.testing.transaction.TransactionUtil;
import org.hibernate.type.BlobType;
import org.hibernate.type.ClobType;
import org.hibernate.type.NClobType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class BaseNonConfigCoreFunctionalTestCase
extends BaseUnitTestCase {
    public static final String VALIDATE_DATA_CLEANUP = "hibernate.test.validateDataCleanup";
    private StandardServiceRegistry serviceRegistry;
    private MetadataImplementor metadata;
    private SessionFactoryImplementor sessionFactory;
    private Session session;
    protected static final String[] NO_MAPPINGS = new String[0];
    protected static final Class[] NO_CLASSES = new Class[0];

    protected Dialect getDialect() {
        if (this.serviceRegistry != null) {
            return ((JdbcEnvironment)this.serviceRegistry.getService(JdbcEnvironment.class)).getDialect();
        }
        return BaseCoreFunctionalTestCase.getDialect();
    }

    protected StandardServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    protected MetadataImplementor metadata() {
        return this.metadata;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    protected Session openSession() throws HibernateException {
        this.session = this.sessionFactory().openSession();
        return this.session;
    }

    protected Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.sessionFactory().withOptions().interceptor(interceptor).openSession();
        return this.session;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void rebuildSessionFactory() {
        this.releaseResources();
        this.buildResources();
    }

    protected void cleanupCache() {
        if (this.sessionFactory != null) {
            this.sessionFactory.getCache().evictAllRegions();
        }
    }

    @BeforeClassOnce
    protected void startUp() {
        this.buildResources();
    }

    protected void buildResources() {
        StandardServiceRegistryBuilder ssrb = this.constructStandardServiceRegistryBuilder();
        this.serviceRegistry = ssrb.build();
        this.afterStandardServiceRegistryBuilt(this.serviceRegistry);
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
        this.applyMetadataSources(metadataSources);
        this.afterMetadataSourcesApplied(metadataSources);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        this.initialize(metadataBuilder);
        this.configureMetadataBuilder(metadataBuilder);
        this.metadata = (MetadataImplementor)metadataBuilder.build();
        this.applyCacheSettings((Metadata)this.metadata);
        this.afterMetadataBuilt((Metadata)this.metadata);
        SessionFactoryBuilder sfb = this.metadata.getSessionFactoryBuilder();
        this.initialize(sfb, (Metadata)this.metadata);
        this.configureSessionFactoryBuilder(sfb);
        this.sessionFactory = (SessionFactoryImplementor)sfb.build();
        this.afterSessionFactoryBuilt(this.sessionFactory);
    }

    protected final StandardServiceRegistryBuilder constructStandardServiceRegistryBuilder() {
        BootstrapServiceRegistryBuilder bsrb = new BootstrapServiceRegistryBuilder();
        bsrb.applyClassLoader(this.getClass().getClassLoader());
        bsrb.enableAutoClose();
        this.configureBootstrapServiceRegistryBuilder(bsrb);
        BootstrapServiceRegistry bsr = bsrb.build();
        this.afterBootstrapServiceRegistryBuilt(bsr);
        HashMap settings = new HashMap();
        this.addSettings(settings);
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder(bsr);
        this.initialize(ssrb);
        ssrb.applySettings(settings);
        this.configureStandardServiceRegistryBuilder(ssrb);
        return ssrb;
    }

    protected void addSettings(Map settings) {
    }

    protected void configureBootstrapServiceRegistryBuilder(BootstrapServiceRegistryBuilder bsrb) {
    }

    protected void afterBootstrapServiceRegistryBuilt(BootstrapServiceRegistry bsr) {
    }

    private void initialize(StandardServiceRegistryBuilder ssrb) {
        Dialect dialect = BaseCoreFunctionalTestCase.getDialect();
        ssrb.applySetting("hibernate.cache.region.factory_class", (Object)CachingRegionFactory.class.getName());
        ssrb.applySetting("hibernate.id.new_generator_mappings", (Object)"true");
        if (this.createSchema()) {
            ssrb.applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop");
            String secondSchemaName = this.createSecondSchema();
            if (StringHelper.isNotEmpty((String)secondSchemaName)) {
                if (!H2Dialect.class.isInstance(dialect)) {
                    throw new UnsupportedOperationException("Only H2 dialect supports creation of second schema.");
                }
                Helper.createH2Schema(secondSchemaName, ssrb.getSettings());
            }
        }
        ssrb.applySetting("hibernate.dialect", (Object)dialect.getClass().getName());
    }

    protected boolean createSchema() {
        return true;
    }

    protected String createSecondSchema() {
        return null;
    }

    protected void configureStandardServiceRegistryBuilder(StandardServiceRegistryBuilder ssrb) {
    }

    protected void afterStandardServiceRegistryBuilt(StandardServiceRegistry ssr) {
    }

    protected void applyMetadataSources(MetadataSources metadataSources) {
        for (String mapping : this.getMappings()) {
            metadataSources.addResource(this.getBaseForMappings() + mapping);
        }
        for (Class annotatedClass : this.getAnnotatedClasses()) {
            metadataSources.addAnnotatedClass(annotatedClass);
        }
        for (String annotatedPackage : this.getAnnotatedPackages()) {
            metadataSources.addPackage(annotatedPackage);
        }
        for (String ormXmlFile : this.getXmlFiles()) {
            metadataSources.addInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(ormXmlFile));
        }
    }

    protected String[] getMappings() {
        return NO_MAPPINGS;
    }

    protected String getBaseForMappings() {
        return "org/hibernate/test/";
    }

    protected Class[] getAnnotatedClasses() {
        return NO_CLASSES;
    }

    protected String[] getAnnotatedPackages() {
        return NO_MAPPINGS;
    }

    protected String[] getXmlFiles() {
        return NO_MAPPINGS;
    }

    protected void afterMetadataSourcesApplied(MetadataSources metadataSources) {
    }

    protected void initialize(MetadataBuilder metadataBuilder) {
        metadataBuilder.enableNewIdentifierGeneratorSupport(true);
        metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyLegacyJpaImpl.INSTANCE);
    }

    protected void configureMetadataBuilder(MetadataBuilder metadataBuilder) {
    }

    protected boolean overrideCacheStrategy() {
        return true;
    }

    protected String getCacheConcurrencyStrategy() {
        return null;
    }

    protected final void applyCacheSettings(Metadata metadata) {
        if (!this.overrideCacheStrategy()) {
            return;
        }
        if (this.getCacheConcurrencyStrategy() == null) {
            return;
        }
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (entityBinding.isInherited()) continue;
            boolean hasLob = false;
            Iterator props = entityBinding.getPropertyClosureIterator();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                if (!prop.getValue().isSimpleValue() || !this.isLob(((SimpleValue)prop.getValue()).getTypeName())) continue;
                hasLob = true;
                break;
            }
            if (hasLob) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy(this.getCacheConcurrencyStrategy());
        }
        for (Collection collectionBinding : metadata.getCollectionBindings()) {
            boolean isLob = false;
            if (collectionBinding.getElement().isSimpleValue()) {
                isLob = this.isLob(((SimpleValue)collectionBinding.getElement()).getTypeName());
            }
            if (isLob) continue;
            collectionBinding.setCacheConcurrencyStrategy(this.getCacheConcurrencyStrategy());
        }
    }

    private boolean isLob(String typeName) {
        return "blob".equals(typeName) || "clob".equals(typeName) || "nclob".equals(typeName) || Blob.class.getName().equals(typeName) || Clob.class.getName().equals(typeName) || NClob.class.getName().equals(typeName) || BlobType.class.getName().equals(typeName) || ClobType.class.getName().equals(typeName) || NClobType.class.getName().equals(typeName);
    }

    protected void afterMetadataBuilt(Metadata metadata) {
    }

    private void initialize(SessionFactoryBuilder sfb, Metadata metadata) {
    }

    protected void configureSessionFactoryBuilder(SessionFactoryBuilder sfb) {
    }

    protected void afterSessionFactoryBuilt(SessionFactoryImplementor sessionFactory) {
    }

    @AfterClassOnce
    protected void shutDown() {
        this.releaseResources();
    }

    protected void releaseResources() {
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.close();
            }
            catch (Exception e) {
                System.err.println("Unable to release SessionFactory : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.sessionFactory = null;
        if (this.serviceRegistry != null) {
            try {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
            }
            catch (Exception e) {
                System.err.println("Unable to release StandardServiceRegistry : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.serviceRegistry = null;
    }

    @OnFailure
    @OnExpectedFailure
    public void onFailure() {
        if (this.rebuildSessionFactoryOnError()) {
            this.rebuildSessionFactory();
        }
    }

    protected boolean rebuildSessionFactoryOnError() {
        return true;
    }

    @Before
    public final void beforeTest() throws Exception {
        this.prepareTest();
    }

    protected void prepareTest() throws Exception {
    }

    @After
    public final void afterTest() throws Exception {
        this.completeStrayTransaction();
        if (this.isCleanupTestDataRequired()) {
            this.cleanupTestData();
        }
        this.cleanupTest();
        this.cleanupSession();
        this.assertAllDataRemoved();
    }

    private void completeStrayTransaction() {
        if (this.session == null) {
            return;
        }
        if (((SessionImplementor)this.session).isClosed()) {
            return;
        }
        if (!this.session.isConnected()) {
            return;
        }
        TransactionCoordinator.TransactionDriver tdc = ((SessionImplementor)this.session).getTransactionCoordinator().getTransactionDriverControl();
        if (tdc.getStatus().canRollback()) {
            this.session.getTransaction().rollback();
        }
    }

    protected boolean isCleanupTestDataRequired() {
        return false;
    }

    protected void cleanupTestData() throws Exception {
        TransactionUtil.doInHibernate(this::sessionFactory, s -> s.createQuery("delete from java.lang.Object").executeUpdate());
    }

    private void cleanupSession() {
        if (this.session != null && !((SessionImplementor)this.session).isClosed()) {
            this.session.close();
        }
        this.session = null;
    }

    protected void cleanupTest() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAllDataRemoved() {
        if (!this.createSchema()) {
            return;
        }
        if (!Boolean.getBoolean(VALIDATE_DATA_CLEANUP)) {
            return;
        }
        Session tmpSession = this.sessionFactory.openSession();
        try {
            List list = tmpSession.createQuery("select o from java.lang.Object o").list();
            HashMap<String, Integer> items = new HashMap<String, Integer>();
            if (!list.isEmpty()) {
                for (Object element : list) {
                    Integer l = (Integer)items.get(tmpSession.getEntityName(element));
                    if (l == null) {
                        l = 0;
                    }
                    l = l + 1;
                    items.put(tmpSession.getEntityName(element), l);
                    System.out.println("Data left: " + element);
                }
                Assert.fail((String)("Data is left in the database: " + ((Object)items).toString()));
            }
        }
        finally {
            try {
                tmpSession.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void inSession(Consumer<SessionImplementor> action) {
        this.log.trace((Object)"#inSession(action)");
        this.inSession(this.sessionFactory(), action);
    }

    public void inTransaction(Consumer<SessionImplementor> action) {
        this.log.trace((Object)"#inTransaction(action)");
        this.inTransaction(this.sessionFactory(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inSession(SessionFactoryImplementor sfi, Consumer<SessionImplementor> action) {
        this.log.trace((Object)"##inSession(SF,action)");
        try (SessionImplementor session = (SessionImplementor)sfi.openSession();){
            this.log.trace((Object)"Session opened, calling action");
            action.accept(session);
            this.log.trace((Object)"called action");
        }
        finally {
            this.log.trace((Object)"Session close - auto-close lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inTransaction(SessionFactoryImplementor factory, Consumer<SessionImplementor> action) {
        this.log.trace((Object)"#inTransaction(factory, action)");
        try (SessionImplementor session = (SessionImplementor)factory.openSession();){
            this.log.trace((Object)"Session opened, calling action");
            this.inTransaction(session, action);
            this.log.trace((Object)"called action");
        }
        finally {
            this.log.trace((Object)"Session close - auto-close lock");
        }
    }

    public void inTransaction(SessionImplementor session, Consumer<SessionImplementor> action) {
        this.log.trace((Object)"inTransaction(session,action)");
        Transaction txn = session.beginTransaction();
        this.log.trace((Object)"Started transaction");
        try {
            this.log.trace((Object)"Calling action in txn");
            action.accept(session);
            this.log.trace((Object)"Called action - in txn");
            this.log.trace((Object)"Committing transaction");
            txn.commit();
            this.log.trace((Object)"Committed transaction");
        }
        catch (Exception e) {
            this.log.tracef("Error calling action: %s (%s) - rolling back", (Object)e.getClass().getName(), (Object)e.getMessage());
            try {
                txn.rollback();
            }
            catch (Exception ignore) {
                this.log.trace((Object)"Was unable to roll back transaction");
            }
            throw e;
        }
    }

    public class RollbackWork
    implements Work {
        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

