/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;

public final class ExtraAssertions {
    private static Map<Integer, String> jdbcTypeCodeMap;

    private ExtraAssertions() {
    }

    public static void assertClassAssignability(Class expected, Class actual) {
        if (!expected.isAssignableFrom(actual)) {
            Assertions.fail((String)("Expected class [" + expected.getName() + "] was not assignable from actual [" + actual.getName() + "]"));
        }
    }

    public static <T> T assertTyping(Class<T> expectedType, Object value) {
        if (!expectedType.isInstance(value)) {
            Assertions.fail((String)String.format("Expecting value of type [%s], but found [%s]", expectedType.getName(), value == null ? "<null>" : value));
        }
        return (T)value;
    }

    public static void assertJdbcTypeCode(int expected, int actual) {
        if (expected != actual) {
            String message = String.format("JDBC type codes did not match...\nExpected: %s (%s)\nActual  : %s (%s)", ExtraAssertions.jdbcTypeCodeMap().get(expected), expected, ExtraAssertions.jdbcTypeCodeMap().get(actual), actual);
            Assertions.fail((String)message);
        }
    }

    private static synchronized Map<Integer, String> jdbcTypeCodeMap() {
        if (jdbcTypeCodeMap == null) {
            jdbcTypeCodeMap = ExtraAssertions.generateJdbcTypeCache();
        }
        return jdbcTypeCodeMap;
    }

    private static Map<Integer, String> generateJdbcTypeCache() {
        Field[] fields = Types.class.getFields();
        HashMap<Integer, String> cache = new HashMap<Integer, String>((int)((double)fields.length * 0.75) + 1);
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                cache.put((Integer)field.get(null), field.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cache;
    }
}

