/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.Locale;
import java.util.Optional;
import org.hibernate.testing.orm.junit.FailureExpectedExtension;
import org.hibernate.testing.orm.junit.NotImplementedYet;
import org.hibernate.testing.orm.junit.TestingUtil;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class NotImplementedYetExtension
implements ExecutionCondition,
BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(NotImplementedYetExtension.class);
    private static final String IS_MARKED_STORE_KEY = "IS_MARKED";
    private static final String EXCEPTION_STORE_KEY = "NOT_IMPLEMENTED";

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        log.debugf("#evaluateExecutionCondition(%s)", (Object)context.getDisplayName());
        if (context.getElement().isEmpty()) {
            throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
        }
        log.debugf("Evaluating context - %s [failureExpectedValidation = %s]", (Object)context.getDisplayName(), (Object)FailureExpectedExtension.failureExpectedValidation);
        if (TestingUtil.hasEffectiveAnnotation(context, NotImplementedYet.class)) {
            if (FailureExpectedExtension.failureExpectedValidation) {
                log.debugf("Executing test marked with `@NotImplementedYet` for validation", new Object[0]);
                return ConditionEvaluationResult.enabled((String)"@NotImplementedYet validation");
            }
            Optional<NotImplementedYet> annotation = TestingUtil.findEffectiveAnnotation(context, NotImplementedYet.class);
            return ConditionEvaluationResult.disabled((String)("Disabled : @NotImplementedYet - " + annotation.get().reason()));
        }
        return ConditionEvaluationResult.enabled((String)"No @NotImplementedYet");
    }

    public void beforeEach(ExtensionContext context) {
        log.tracef("#beforeEach(%s)", (Object)context.getDisplayName());
        Optional<NotImplementedYet> annRef = TestingUtil.findEffectiveAnnotation(context, NotImplementedYet.class);
        boolean isMarked = annRef.isPresent();
        log.debugf("Checking `%s` for @NotImplementedYet - isMarked = %s", (Object)context.getDisplayName(), (Object)isMarked);
        ExtensionContext.Namespace namespace = this.generateNamespace(context);
        context.getStore(namespace).put((Object)IS_MARKED_STORE_KEY, (Object)isMarked);
    }

    public void afterEach(ExtensionContext context) {
        log.debugf("#afterEach(%s)", (Object)context.getDisplayName());
        ExtensionContext.Namespace namespace = this.generateNamespace(context);
        ExtensionContext.Store store = context.getStore(namespace);
        Boolean isMarked = (Boolean)store.remove((Object)IS_MARKED_STORE_KEY);
        log.debugf("Post-handling for @FailureExpected [%s] - %s", (Object)context.getDisplayName(), (Object)isMarked);
        if (isMarked == Boolean.TRUE) {
            Throwable expectedFailure = (Throwable)store.remove((Object)EXCEPTION_STORE_KEY);
            log.debugf("  >> Captured exception - %s", (Object)expectedFailure);
            if (expectedFailure == null) {
                throw new NotImplementedYetExceptionExpected(context.getRequiredTestClass().getName(), context.getRequiredTestMethod().getName());
            }
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        log.debugf("#handleTestExecutionException(%s)", (Object)context.getDisplayName());
        ExtensionContext.Namespace namespace = this.generateNamespace(context);
        ExtensionContext.Store store = context.getStore(namespace);
        Boolean isMarked = (Boolean)store.get((Object)IS_MARKED_STORE_KEY);
        if (isMarked.booleanValue()) {
            store.put((Object)EXCEPTION_STORE_KEY, (Object)throwable);
            log.debugf("#Captured exception %s - ignoring it as expected", (Object)throwable);
            return;
        }
        throw throwable;
    }

    private ExtensionContext.Namespace generateNamespace(ExtensionContext context) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass().getName(), context.getRequiredTestMethod().getClass(), context.getRequiredTestMethod().getName()});
    }

    public static class NotImplementedYetExceptionExpected
    extends RuntimeException {
        private NotImplementedYetExceptionExpected(String testClassName, String testMethodName) {
            super(String.format(Locale.ROOT, "`%s#%s` is marked with `@NotImplementedYet`, however the test did not fail.  If the functionality has been implemented the `@NotImplementedYet` annotation should be removed", testClassName, testMethodName));
        }
    }
}

