/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jta;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.testing.jta.TestingJtaPlatformImpl;

public class JtaAwareConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService {
    private static final String CONNECTION_KEY = "_database_connection";
    private final DriverManagerConnectionProviderImpl delegate = new DriverManagerConnectionProviderImpl();
    private final List<Connection> nonEnlistedConnections = new ArrayList<Connection>();

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.delegate.injectServices(serviceRegistry);
    }

    public void configure(Map<String, Object> configurationValues) {
        HashMap<String, Object> connectionSettings = new HashMap<String, Object>();
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.driver_class", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.url", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.username", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.password", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.isolation", configurationValues, connectionSettings);
        Properties passThroughSettings = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
        for (String setting : passThroughSettings.stringPropertyNames()) {
            JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection." + setting, configurationValues, connectionSettings);
        }
        connectionSettings.remove("hibernate.connection.handling_mode");
        connectionSettings.put("hibernate.connection.autocommit", "false");
        connectionSettings.put("hibernate.connection.pool_size", "5");
        connectionSettings.put("hibernate.connection.initial_pool_size", "0");
        this.delegate.configure(connectionSettings);
    }

    private static void transferSetting(String settingName, Map<String, Object> source, Map<String, Object> target) {
        Object value = source.get(settingName);
        if (value != null) {
            target.put(settingName, value);
        }
    }

    public void stop() {
        this.delegate.stop();
    }

    public Connection getConnection() throws SQLException {
        Transaction currentTransaction = this.findCurrentTransaction();
        try {
            if (currentTransaction == null) {
                Connection connection = this.delegate.getConnection();
                this.nonEnlistedConnections.add(connection);
                return connection;
            }
            Connection connection = (Connection)TestingJtaPlatformImpl.synchronizationRegistry().getResource((Object)CONNECTION_KEY);
            if (connection == null) {
                ConnectionWrapper c = new ConnectionWrapper(this.delegate.getConnection());
                TestingJtaPlatformImpl.synchronizationRegistry().putResource((Object)CONNECTION_KEY, (Object)c);
                try {
                    XAResourceWrapper xaResourceWrapper = new XAResourceWrapper(this, c);
                    currentTransaction.enlistResource((XAResource)xaResourceWrapper);
                }
                catch (Exception e) {
                    this.delist(c);
                    throw e;
                }
                return c;
            }
            return connection;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void closeConnection(Connection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        if (this.nonEnlistedConnections.contains(connection)) {
            this.nonEnlistedConnections.remove(connection);
            this.delegate.closeConnection(connection);
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return this.delegate.getDatabaseConnectionInfo(dialect);
    }

    protected Transaction findCurrentTransaction() {
        try {
            return TestingJtaPlatformImpl.transactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Could not locate current transaction");
        }
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return this.delegate.isUnwrappableAs(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.delegate.unwrap(unwrapType);
    }

    @AllowSysOut
    private void delist(Connection connection) {
        try {
            TestingJtaPlatformImpl.synchronizationRegistry().putResource((Object)CONNECTION_KEY, null);
        }
        catch (Exception e) {
            System.err.println("!!!Error trying to reset synchronization registry!!!");
        }
        try {
            this.delegate.closeConnection(connection);
        }
        catch (SQLException e) {
            System.err.println("!!!Error trying to close JDBC connection from delist callbacks!!!");
        }
    }

    private static class CallableStatementWrapper
    implements CallableStatement {
        private final CallableStatement delegate;
        private final ConnectionWrapper connectionWrapper;

        public CallableStatementWrapper(CallableStatement delegate, ConnectionWrapper connectionWrapper) {
            this.delegate = delegate;
            this.connectionWrapper = connectionWrapper;
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
            this.delegate.registerOutParameter(parameterIndex, sqlType);
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
            this.delegate.registerOutParameter(parameterIndex, sqlType, scale);
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.delegate.wasNull();
        }

        @Override
        public String getString(int parameterIndex) throws SQLException {
            return this.delegate.getString(parameterIndex);
        }

        @Override
        public boolean getBoolean(int parameterIndex) throws SQLException {
            return this.delegate.getBoolean(parameterIndex);
        }

        @Override
        public byte getByte(int parameterIndex) throws SQLException {
            return this.delegate.getByte(parameterIndex);
        }

        @Override
        public short getShort(int parameterIndex) throws SQLException {
            return this.delegate.getShort(parameterIndex);
        }

        @Override
        public int getInt(int parameterIndex) throws SQLException {
            return this.delegate.getInt(parameterIndex);
        }

        @Override
        public long getLong(int parameterIndex) throws SQLException {
            return this.delegate.getLong(parameterIndex);
        }

        @Override
        public float getFloat(int parameterIndex) throws SQLException {
            return this.delegate.getFloat(parameterIndex);
        }

        @Override
        public double getDouble(int parameterIndex) throws SQLException {
            return this.delegate.getDouble(parameterIndex);
        }

        @Override
        @Deprecated(since="1.2")
        public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
            return this.delegate.getBigDecimal(parameterIndex, scale);
        }

        @Override
        public byte[] getBytes(int parameterIndex) throws SQLException {
            return this.delegate.getBytes(parameterIndex);
        }

        @Override
        public Date getDate(int parameterIndex) throws SQLException {
            return this.delegate.getDate(parameterIndex);
        }

        @Override
        public Time getTime(int parameterIndex) throws SQLException {
            return this.delegate.getTime(parameterIndex);
        }

        @Override
        public Timestamp getTimestamp(int parameterIndex) throws SQLException {
            return this.delegate.getTimestamp(parameterIndex);
        }

        @Override
        public Object getObject(int parameterIndex) throws SQLException {
            return this.delegate.getObject(parameterIndex);
        }

        @Override
        public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
            return this.delegate.getBigDecimal(parameterIndex);
        }

        @Override
        public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
            return this.delegate.getObject(parameterIndex, map);
        }

        @Override
        public Ref getRef(int parameterIndex) throws SQLException {
            return this.delegate.getRef(parameterIndex);
        }

        @Override
        public Blob getBlob(int parameterIndex) throws SQLException {
            return this.delegate.getBlob(parameterIndex);
        }

        @Override
        public Clob getClob(int parameterIndex) throws SQLException {
            return this.delegate.getClob(parameterIndex);
        }

        @Override
        public Array getArray(int parameterIndex) throws SQLException {
            return this.delegate.getArray(parameterIndex);
        }

        @Override
        public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
            return this.delegate.getDate(parameterIndex, cal);
        }

        @Override
        public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
            return this.delegate.getTime(parameterIndex, cal);
        }

        @Override
        public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
            return this.delegate.getTimestamp(parameterIndex, cal);
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
            this.delegate.registerOutParameter(parameterIndex, sqlType, typeName);
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
            this.delegate.registerOutParameter(parameterName, sqlType);
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
            this.delegate.registerOutParameter(parameterName, sqlType, scale);
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
            this.delegate.registerOutParameter(parameterName, sqlType, typeName);
        }

        @Override
        public URL getURL(int parameterIndex) throws SQLException {
            return this.delegate.getURL(parameterIndex);
        }

        @Override
        public void setURL(String parameterName, URL val) throws SQLException {
            this.delegate.setURL(parameterName, val);
        }

        @Override
        public void setNull(String parameterName, int sqlType) throws SQLException {
            this.delegate.setNull(parameterName, sqlType);
        }

        @Override
        public void setBoolean(String parameterName, boolean x) throws SQLException {
            this.delegate.setBoolean(parameterName, x);
        }

        @Override
        public void setByte(String parameterName, byte x) throws SQLException {
            this.delegate.setByte(parameterName, x);
        }

        @Override
        public void setShort(String parameterName, short x) throws SQLException {
            this.delegate.setShort(parameterName, x);
        }

        @Override
        public void setInt(String parameterName, int x) throws SQLException {
            this.delegate.setInt(parameterName, x);
        }

        @Override
        public void setLong(String parameterName, long x) throws SQLException {
            this.delegate.setLong(parameterName, x);
        }

        @Override
        public void setFloat(String parameterName, float x) throws SQLException {
            this.delegate.setFloat(parameterName, x);
        }

        @Override
        public void setDouble(String parameterName, double x) throws SQLException {
            this.delegate.setDouble(parameterName, x);
        }

        @Override
        public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
            this.delegate.setBigDecimal(parameterName, x);
        }

        @Override
        public void setString(String parameterName, String x) throws SQLException {
            this.delegate.setString(parameterName, x);
        }

        @Override
        public void setBytes(String parameterName, byte[] x) throws SQLException {
            this.delegate.setBytes(parameterName, x);
        }

        @Override
        public void setDate(String parameterName, Date x) throws SQLException {
            this.delegate.setDate(parameterName, x);
        }

        @Override
        public void setTime(String parameterName, Time x) throws SQLException {
            this.delegate.setTime(parameterName, x);
        }

        @Override
        public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
            this.delegate.setTimestamp(parameterName, x);
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
            this.delegate.setAsciiStream(parameterName, x, length);
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
            this.delegate.setBinaryStream(parameterName, x, length);
        }

        @Override
        public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
            this.delegate.setObject(parameterName, x, targetSqlType, scale);
        }

        @Override
        public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
            this.delegate.setObject(parameterName, x, targetSqlType);
        }

        @Override
        public void setObject(String parameterName, Object x) throws SQLException {
            this.delegate.setObject(parameterName, x);
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
            this.delegate.setCharacterStream(parameterName, reader, length);
        }

        @Override
        public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
            this.delegate.setDate(parameterName, x, cal);
        }

        @Override
        public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
            this.delegate.setTime(parameterName, x, cal);
        }

        @Override
        public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
            this.delegate.setTimestamp(parameterName, x, cal);
        }

        @Override
        public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
            this.delegate.setNull(parameterName, sqlType, typeName);
        }

        @Override
        public String getString(String parameterName) throws SQLException {
            return this.delegate.getString(parameterName);
        }

        @Override
        public boolean getBoolean(String parameterName) throws SQLException {
            return this.delegate.getBoolean(parameterName);
        }

        @Override
        public byte getByte(String parameterName) throws SQLException {
            return this.delegate.getByte(parameterName);
        }

        @Override
        public short getShort(String parameterName) throws SQLException {
            return this.delegate.getShort(parameterName);
        }

        @Override
        public int getInt(String parameterName) throws SQLException {
            return this.delegate.getInt(parameterName);
        }

        @Override
        public long getLong(String parameterName) throws SQLException {
            return this.delegate.getLong(parameterName);
        }

        @Override
        public float getFloat(String parameterName) throws SQLException {
            return this.delegate.getFloat(parameterName);
        }

        @Override
        public double getDouble(String parameterName) throws SQLException {
            return this.delegate.getDouble(parameterName);
        }

        @Override
        public byte[] getBytes(String parameterName) throws SQLException {
            return this.delegate.getBytes(parameterName);
        }

        @Override
        public Date getDate(String parameterName) throws SQLException {
            return this.delegate.getDate(parameterName);
        }

        @Override
        public Time getTime(String parameterName) throws SQLException {
            return this.delegate.getTime(parameterName);
        }

        @Override
        public Timestamp getTimestamp(String parameterName) throws SQLException {
            return this.delegate.getTimestamp(parameterName);
        }

        @Override
        public Object getObject(String parameterName) throws SQLException {
            return this.delegate.getObject(parameterName);
        }

        @Override
        public BigDecimal getBigDecimal(String parameterName) throws SQLException {
            return this.delegate.getBigDecimal(parameterName);
        }

        @Override
        public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
            return this.delegate.getObject(parameterName, map);
        }

        @Override
        public Ref getRef(String parameterName) throws SQLException {
            return this.delegate.getRef(parameterName);
        }

        @Override
        public Blob getBlob(String parameterName) throws SQLException {
            return this.delegate.getBlob(parameterName);
        }

        @Override
        public Clob getClob(String parameterName) throws SQLException {
            return this.delegate.getClob(parameterName);
        }

        @Override
        public Array getArray(String parameterName) throws SQLException {
            return this.delegate.getArray(parameterName);
        }

        @Override
        public Date getDate(String parameterName, Calendar cal) throws SQLException {
            return this.delegate.getDate(parameterName, cal);
        }

        @Override
        public Time getTime(String parameterName, Calendar cal) throws SQLException {
            return this.delegate.getTime(parameterName, cal);
        }

        @Override
        public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
            return this.delegate.getTimestamp(parameterName, cal);
        }

        @Override
        public URL getURL(String parameterName) throws SQLException {
            return this.delegate.getURL(parameterName);
        }

        @Override
        public RowId getRowId(int parameterIndex) throws SQLException {
            return this.delegate.getRowId(parameterIndex);
        }

        @Override
        public RowId getRowId(String parameterName) throws SQLException {
            return this.delegate.getRowId(parameterName);
        }

        @Override
        public void setRowId(String parameterName, RowId x) throws SQLException {
            this.delegate.setRowId(parameterName, x);
        }

        @Override
        public void setNString(String parameterName, String value) throws SQLException {
            this.delegate.setNString(parameterName, value);
        }

        @Override
        public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
            this.delegate.setNCharacterStream(parameterName, value, length);
        }

        @Override
        public void setNClob(String parameterName, NClob value) throws SQLException {
            this.delegate.setNClob(parameterName, value);
        }

        @Override
        public void setClob(String parameterName, Reader reader, long length) throws SQLException {
            this.delegate.setClob(parameterName, reader, length);
        }

        @Override
        public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
            this.delegate.setBlob(parameterName, inputStream, length);
        }

        @Override
        public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
            this.delegate.setNClob(parameterName, reader, length);
        }

        @Override
        public NClob getNClob(int parameterIndex) throws SQLException {
            return this.delegate.getNClob(parameterIndex);
        }

        @Override
        public NClob getNClob(String parameterName) throws SQLException {
            return this.delegate.getNClob(parameterName);
        }

        @Override
        public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
            this.delegate.setSQLXML(parameterName, xmlObject);
        }

        @Override
        public SQLXML getSQLXML(int parameterIndex) throws SQLException {
            return this.delegate.getSQLXML(parameterIndex);
        }

        @Override
        public SQLXML getSQLXML(String parameterName) throws SQLException {
            return this.delegate.getSQLXML(parameterName);
        }

        @Override
        public String getNString(int parameterIndex) throws SQLException {
            return this.delegate.getNString(parameterIndex);
        }

        @Override
        public String getNString(String parameterName) throws SQLException {
            return this.delegate.getNString(parameterName);
        }

        @Override
        public Reader getNCharacterStream(int parameterIndex) throws SQLException {
            return this.delegate.getNCharacterStream(parameterIndex);
        }

        @Override
        public Reader getNCharacterStream(String parameterName) throws SQLException {
            return this.delegate.getNCharacterStream(parameterName);
        }

        @Override
        public Reader getCharacterStream(int parameterIndex) throws SQLException {
            return this.delegate.getCharacterStream(parameterIndex);
        }

        @Override
        public Reader getCharacterStream(String parameterName) throws SQLException {
            return this.delegate.getCharacterStream(parameterName);
        }

        @Override
        public void setBlob(String parameterName, Blob x) throws SQLException {
            this.delegate.setBlob(parameterName, x);
        }

        @Override
        public void setClob(String parameterName, Clob x) throws SQLException {
            this.delegate.setClob(parameterName, x);
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
            this.delegate.setAsciiStream(parameterName, x, length);
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
            this.delegate.setBinaryStream(parameterName, x, length);
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
            this.delegate.setCharacterStream(parameterName, reader, length);
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
            this.delegate.setAsciiStream(parameterName, x);
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
            this.delegate.setBinaryStream(parameterName, x);
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
            this.delegate.setCharacterStream(parameterName, reader);
        }

        @Override
        public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
            this.delegate.setNCharacterStream(parameterName, value);
        }

        @Override
        public void setClob(String parameterName, Reader reader) throws SQLException {
            this.delegate.setClob(parameterName, reader);
        }

        @Override
        public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
            this.delegate.setBlob(parameterName, inputStream);
        }

        @Override
        public void setNClob(String parameterName, Reader reader) throws SQLException {
            this.delegate.setNClob(parameterName, reader);
        }

        @Override
        public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
            return this.delegate.getObject(parameterIndex, type);
        }

        @Override
        public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
            return this.delegate.getObject(parameterName, type);
        }

        @Override
        public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
            this.delegate.setObject(parameterName, x, targetSqlType, scaleOrLength);
        }

        @Override
        public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
            this.delegate.setObject(parameterName, x, targetSqlType);
        }

        @Override
        public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
            this.delegate.registerOutParameter(parameterIndex, sqlType);
        }

        @Override
        public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
            this.delegate.registerOutParameter(parameterIndex, sqlType, scale);
        }

        @Override
        public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
            this.delegate.registerOutParameter(parameterIndex, sqlType, typeName);
        }

        @Override
        public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
            this.delegate.registerOutParameter(parameterName, sqlType);
        }

        @Override
        public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
            this.delegate.registerOutParameter(parameterName, sqlType, scale);
        }

        @Override
        public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
            this.delegate.registerOutParameter(parameterName, sqlType, typeName);
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                ResultSet resultSet = this.delegate.executeQuery();
                return resultSet;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int executeUpdate() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate();
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            this.delegate.setNull(parameterIndex, sqlType);
        }

        @Override
        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            this.delegate.setBoolean(parameterIndex, x);
        }

        @Override
        public void setByte(int parameterIndex, byte x) throws SQLException {
            this.delegate.setByte(parameterIndex, x);
        }

        @Override
        public void setShort(int parameterIndex, short x) throws SQLException {
            this.delegate.setShort(parameterIndex, x);
        }

        @Override
        public void setInt(int parameterIndex, int x) throws SQLException {
            this.delegate.setInt(parameterIndex, x);
        }

        @Override
        public void setLong(int parameterIndex, long x) throws SQLException {
            this.delegate.setLong(parameterIndex, x);
        }

        @Override
        public void setFloat(int parameterIndex, float x) throws SQLException {
            this.delegate.setFloat(parameterIndex, x);
        }

        @Override
        public void setDouble(int parameterIndex, double x) throws SQLException {
            this.delegate.setDouble(parameterIndex, x);
        }

        @Override
        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.delegate.setBigDecimal(parameterIndex, x);
        }

        @Override
        public void setString(int parameterIndex, String x) throws SQLException {
            this.delegate.setString(parameterIndex, x);
        }

        @Override
        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            this.delegate.setBytes(parameterIndex, x);
        }

        @Override
        public void setDate(int parameterIndex, Date x) throws SQLException {
            this.delegate.setDate(parameterIndex, x);
        }

        @Override
        public void setTime(int parameterIndex, Time x) throws SQLException {
            this.delegate.setTime(parameterIndex, x);
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            this.delegate.setTimestamp(parameterIndex, x);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }

        @Override
        @Deprecated(since="1.2")
        public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.delegate.setUnicodeStream(parameterIndex, x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }

        @Override
        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }

        @Override
        public void setObject(int parameterIndex, Object x) throws SQLException {
            this.delegate.setObject(parameterIndex, x);
        }

        @Override
        public boolean execute() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute();
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }

        @Override
        public void setRef(int parameterIndex, Ref x) throws SQLException {
            this.delegate.setRef(parameterIndex, x);
        }

        @Override
        public void setBlob(int parameterIndex, Blob x) throws SQLException {
            this.delegate.setBlob(parameterIndex, x);
        }

        @Override
        public void setClob(int parameterIndex, Clob x) throws SQLException {
            this.delegate.setClob(parameterIndex, x);
        }

        @Override
        public void setArray(int parameterIndex, Array x) throws SQLException {
            this.delegate.setArray(parameterIndex, x);
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this.delegate.getMetaData();
        }

        @Override
        public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
            this.delegate.setDate(parameterIndex, x, cal);
        }

        @Override
        public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
            this.delegate.setTime(parameterIndex, x, cal);
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
            this.delegate.setTimestamp(parameterIndex, x, cal);
        }

        @Override
        public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
            this.delegate.setNull(parameterIndex, sqlType, typeName);
        }

        @Override
        public void setURL(int parameterIndex, URL x) throws SQLException {
            this.delegate.setURL(parameterIndex, x);
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.delegate.getParameterMetaData();
        }

        @Override
        public void setRowId(int parameterIndex, RowId x) throws SQLException {
            this.delegate.setRowId(parameterIndex, x);
        }

        @Override
        public void setNString(int parameterIndex, String value) throws SQLException {
            this.delegate.setNString(parameterIndex, value);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
            this.delegate.setNCharacterStream(parameterIndex, value, length);
        }

        @Override
        public void setNClob(int parameterIndex, NClob value) throws SQLException {
            this.delegate.setNClob(parameterIndex, value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.delegate.setClob(parameterIndex, reader, length);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
            this.delegate.setBlob(parameterIndex, inputStream, length);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.delegate.setNClob(parameterIndex, reader, length);
        }

        @Override
        public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
            this.delegate.setSQLXML(parameterIndex, xmlObject);
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
            this.delegate.setAsciiStream(parameterIndex, x);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
            this.delegate.setBinaryStream(parameterIndex, x);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
            this.delegate.setCharacterStream(parameterIndex, reader);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
            this.delegate.setNCharacterStream(parameterIndex, value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader) throws SQLException {
            this.delegate.setClob(parameterIndex, reader);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
            this.delegate.setBlob(parameterIndex, inputStream);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader) throws SQLException {
            this.delegate.setNClob(parameterIndex, reader);
        }

        @Override
        public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }

        @Override
        public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }

        @Override
        public long executeLargeUpdate() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate();
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                ResultSet resultSet = this.delegate.executeQuery(sql);
                return resultSet;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void close() throws SQLException {
            this.delegate.close();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            this.delegate.setMaxFieldSize(max);
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            this.delegate.setMaxRows(max);
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.delegate.setEscapeProcessing(enable);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            this.delegate.setQueryTimeout(seconds);
        }

        @Override
        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            this.delegate.setCursorName(name);
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.delegate.setFetchDirection(direction);
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.delegate.setFetchSize(rows);
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            this.delegate.addBatch(sql);
        }

        @Override
        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        @Override
        public int[] executeBatch() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int[] nArray = this.delegate.executeBatch();
                return nArray;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.connectionWrapper;
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return this.delegate.getMoreResults(current);
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, autoGeneratedKeys);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, columnIndexes);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, columnNames);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, autoGeneratedKeys);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, columnIndexes);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, columnNames);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate.isClosed();
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            this.delegate.setPoolable(poolable);
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.delegate.isPoolable();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            this.delegate.closeOnCompletion();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return this.delegate.isCloseOnCompletion();
        }

        @Override
        public long getLargeUpdateCount() throws SQLException {
            return this.delegate.getLargeUpdateCount();
        }

        @Override
        public void setLargeMaxRows(long max) throws SQLException {
            this.delegate.setLargeMaxRows(max);
        }

        @Override
        public long getLargeMaxRows() throws SQLException {
            return this.delegate.getLargeMaxRows();
        }

        @Override
        public long[] executeLargeBatch() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long[] lArray = this.delegate.executeLargeBatch();
                return lArray;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, columnIndexes);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, columnNames);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public String enquoteLiteral(String val) throws SQLException {
            return this.delegate.enquoteLiteral(val);
        }

        @Override
        public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
            return this.delegate.enquoteIdentifier(identifier, alwaysQuote);
        }

        @Override
        public boolean isSimpleIdentifier(String identifier) throws SQLException {
            return this.delegate.isSimpleIdentifier(identifier);
        }

        @Override
        public String enquoteNCharLiteral(String val) throws SQLException {
            return this.delegate.enquoteNCharLiteral(val);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }

    private static class PreparedStatementWrapper
    implements PreparedStatement {
        private final PreparedStatement delegate;
        private final ConnectionWrapper connectionWrapper;

        private PreparedStatementWrapper(PreparedStatement delegate, ConnectionWrapper connectionWrapper) {
            this.delegate = delegate;
            this.connectionWrapper = connectionWrapper;
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                ResultSet resultSet = this.delegate.executeQuery();
                return resultSet;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int executeUpdate() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate();
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            this.delegate.setNull(parameterIndex, sqlType);
        }

        @Override
        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            this.delegate.setBoolean(parameterIndex, x);
        }

        @Override
        public void setByte(int parameterIndex, byte x) throws SQLException {
            this.delegate.setByte(parameterIndex, x);
        }

        @Override
        public void setShort(int parameterIndex, short x) throws SQLException {
            this.delegate.setShort(parameterIndex, x);
        }

        @Override
        public void setInt(int parameterIndex, int x) throws SQLException {
            this.delegate.setInt(parameterIndex, x);
        }

        @Override
        public void setLong(int parameterIndex, long x) throws SQLException {
            this.delegate.setLong(parameterIndex, x);
        }

        @Override
        public void setFloat(int parameterIndex, float x) throws SQLException {
            this.delegate.setFloat(parameterIndex, x);
        }

        @Override
        public void setDouble(int parameterIndex, double x) throws SQLException {
            this.delegate.setDouble(parameterIndex, x);
        }

        @Override
        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.delegate.setBigDecimal(parameterIndex, x);
        }

        @Override
        public void setString(int parameterIndex, String x) throws SQLException {
            this.delegate.setString(parameterIndex, x);
        }

        @Override
        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            this.delegate.setBytes(parameterIndex, x);
        }

        @Override
        public void setDate(int parameterIndex, Date x) throws SQLException {
            this.delegate.setDate(parameterIndex, x);
        }

        @Override
        public void setTime(int parameterIndex, Time x) throws SQLException {
            this.delegate.setTime(parameterIndex, x);
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            this.delegate.setTimestamp(parameterIndex, x);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }

        @Override
        @Deprecated(since="1.2")
        public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.delegate.setUnicodeStream(parameterIndex, x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }

        @Override
        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }

        @Override
        public void setObject(int parameterIndex, Object x) throws SQLException {
            this.delegate.setObject(parameterIndex, x);
        }

        @Override
        public boolean execute() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute();
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }

        @Override
        public void setRef(int parameterIndex, Ref x) throws SQLException {
            this.delegate.setRef(parameterIndex, x);
        }

        @Override
        public void setBlob(int parameterIndex, Blob x) throws SQLException {
            this.delegate.setBlob(parameterIndex, x);
        }

        @Override
        public void setClob(int parameterIndex, Clob x) throws SQLException {
            this.delegate.setClob(parameterIndex, x);
        }

        @Override
        public void setArray(int parameterIndex, Array x) throws SQLException {
            this.delegate.setArray(parameterIndex, x);
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this.delegate.getMetaData();
        }

        @Override
        public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
            this.delegate.setDate(parameterIndex, x, cal);
        }

        @Override
        public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
            this.delegate.setTime(parameterIndex, x, cal);
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
            this.delegate.setTimestamp(parameterIndex, x, cal);
        }

        @Override
        public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
            this.delegate.setNull(parameterIndex, sqlType, typeName);
        }

        @Override
        public void setURL(int parameterIndex, URL x) throws SQLException {
            this.delegate.setURL(parameterIndex, x);
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.delegate.getParameterMetaData();
        }

        @Override
        public void setRowId(int parameterIndex, RowId x) throws SQLException {
            this.delegate.setRowId(parameterIndex, x);
        }

        @Override
        public void setNString(int parameterIndex, String value) throws SQLException {
            this.delegate.setNString(parameterIndex, value);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
            this.delegate.setNCharacterStream(parameterIndex, value, length);
        }

        @Override
        public void setNClob(int parameterIndex, NClob value) throws SQLException {
            this.delegate.setNClob(parameterIndex, value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.delegate.setClob(parameterIndex, reader, length);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
            this.delegate.setBlob(parameterIndex, inputStream, length);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.delegate.setNClob(parameterIndex, reader, length);
        }

        @Override
        public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
            this.delegate.setSQLXML(parameterIndex, xmlObject);
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
            this.delegate.setAsciiStream(parameterIndex, x);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
            this.delegate.setBinaryStream(parameterIndex, x);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
            this.delegate.setCharacterStream(parameterIndex, reader);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
            this.delegate.setNCharacterStream(parameterIndex, value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader) throws SQLException {
            this.delegate.setClob(parameterIndex, reader);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
            this.delegate.setBlob(parameterIndex, inputStream);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader) throws SQLException {
            this.delegate.setNClob(parameterIndex, reader);
        }

        @Override
        public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }

        @Override
        public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }

        @Override
        public long executeLargeUpdate() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate();
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                ResultSet resultSet = this.delegate.executeQuery(sql);
                return resultSet;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void close() throws SQLException {
            this.delegate.close();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            this.delegate.setMaxFieldSize(max);
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            this.delegate.setMaxRows(max);
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.delegate.setEscapeProcessing(enable);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            this.delegate.setQueryTimeout(seconds);
        }

        @Override
        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            this.delegate.setCursorName(name);
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.delegate.setFetchDirection(direction);
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.delegate.setFetchSize(rows);
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            this.delegate.addBatch(sql);
        }

        @Override
        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        @Override
        public int[] executeBatch() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int[] nArray = this.delegate.executeBatch();
                return nArray;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.connectionWrapper;
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return this.delegate.getMoreResults(current);
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, autoGeneratedKeys);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, columnIndexes);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, columnNames);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, autoGeneratedKeys);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, columnIndexes);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, columnNames);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate.isClosed();
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            this.delegate.setPoolable(poolable);
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.delegate.isPoolable();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            this.delegate.closeOnCompletion();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return this.delegate.isCloseOnCompletion();
        }

        @Override
        public long getLargeUpdateCount() throws SQLException {
            return this.delegate.getLargeUpdateCount();
        }

        @Override
        public void setLargeMaxRows(long max) throws SQLException {
            this.delegate.setLargeMaxRows(max);
        }

        @Override
        public long getLargeMaxRows() throws SQLException {
            return this.delegate.getLargeMaxRows();
        }

        @Override
        public long[] executeLargeBatch() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long[] lArray = this.delegate.executeLargeBatch();
                return lArray;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, columnIndexes);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, columnNames);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public String enquoteLiteral(String val) throws SQLException {
            return this.delegate.enquoteLiteral(val);
        }

        @Override
        public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
            return this.delegate.enquoteIdentifier(identifier, alwaysQuote);
        }

        @Override
        public boolean isSimpleIdentifier(String identifier) throws SQLException {
            return this.delegate.isSimpleIdentifier(identifier);
        }

        @Override
        public String enquoteNCharLiteral(String val) throws SQLException {
            return this.delegate.enquoteNCharLiteral(val);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }

    private static class StatementWrapper
    implements Statement {
        private final Statement delegate;
        private final ConnectionWrapper connectionWrapper;

        public StatementWrapper(Statement delegate, ConnectionWrapper connectionWrapper) {
            this.delegate = delegate;
            this.connectionWrapper = connectionWrapper;
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                ResultSet resultSet = this.delegate.executeQuery(sql);
                return resultSet;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public void close() throws SQLException {
            this.delegate.close();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            this.delegate.setMaxFieldSize(max);
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            this.delegate.setMaxRows(max);
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.delegate.setEscapeProcessing(enable);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            this.delegate.setQueryTimeout(seconds);
        }

        @Override
        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            this.delegate.setCursorName(name);
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.delegate.setFetchDirection(direction);
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.delegate.setFetchSize(rows);
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            this.delegate.addBatch(sql);
        }

        @Override
        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        @Override
        public int[] executeBatch() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int[] nArray = this.delegate.executeBatch();
                return nArray;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.connectionWrapper;
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return this.delegate.getMoreResults(current);
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, autoGeneratedKeys);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, columnIndexes);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                int n = this.delegate.executeUpdate(sql, columnNames);
                return n;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, autoGeneratedKeys);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, columnIndexes);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                boolean bl = this.delegate.execute(sql, columnNames);
                return bl;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate.isClosed();
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            this.delegate.setPoolable(poolable);
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.delegate.isPoolable();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            this.delegate.closeOnCompletion();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return this.delegate.isCloseOnCompletion();
        }

        @Override
        public long getLargeUpdateCount() throws SQLException {
            return this.delegate.getLargeUpdateCount();
        }

        @Override
        public void setLargeMaxRows(long max) throws SQLException {
            this.delegate.setLargeMaxRows(max);
        }

        @Override
        public long getLargeMaxRows() throws SQLException {
            return this.delegate.getLargeMaxRows();
        }

        @Override
        public long[] executeLargeBatch() throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long[] lArray = this.delegate.executeLargeBatch();
                return lArray;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, columnIndexes);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
            try {
                this.connectionWrapper.setRunningStatement(this.delegate);
                long l = this.delegate.executeLargeUpdate(sql, columnNames);
                return l;
            }
            finally {
                this.connectionWrapper.setRunningStatement(null);
            }
        }

        @Override
        public String enquoteLiteral(String val) throws SQLException {
            return this.delegate.enquoteLiteral(val);
        }

        @Override
        public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
            return this.delegate.enquoteIdentifier(identifier, alwaysQuote);
        }

        @Override
        public boolean isSimpleIdentifier(String identifier) throws SQLException {
            return this.delegate.isSimpleIdentifier(identifier);
        }

        @Override
        public String enquoteNCharLiteral(String val) throws SQLException {
            return this.delegate.enquoteNCharLiteral(val);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }

    public static class ConnectionWrapper
    implements Connection {
        private final Connection delegate;
        private volatile Statement runningStatement;

        private ConnectionWrapper(Connection delegate) {
            this.delegate = delegate;
        }

        public Statement getRunningStatement() {
            return this.runningStatement;
        }

        public void setRunningStatement(Statement runningStatement) {
            this.runningStatement = runningStatement;
        }

        private Statement wrapStatement(Statement statement) {
            return new StatementWrapper(statement, this);
        }

        private PreparedStatement wrapPreparedStatement(PreparedStatement preparedStatement) {
            return new PreparedStatementWrapper(preparedStatement, this);
        }

        private CallableStatement wrapCallableStatement(CallableStatement callableStatement) {
            return new CallableStatementWrapper(callableStatement, this);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.wrapStatement(this.delegate.createStatement());
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.wrapPreparedStatement(this.delegate.prepareStatement(sql));
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.wrapCallableStatement(this.delegate.prepareCall(sql));
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.delegate.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.delegate.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.delegate.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.delegate.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.delegate.rollback();
        }

        @Override
        public void close() throws SQLException {
            this.delegate.close();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.delegate.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.delegate.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.delegate.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.delegate.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.delegate.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.delegate.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.delegate.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapStatement(this.delegate.createStatement(resultSetType, resultSetConcurrency));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapPreparedStatement(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.wrapCallableStatement(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.delegate.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.delegate.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.delegate.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.delegate.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.delegate.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.delegate.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.delegate.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.delegate.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapStatement(this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapPreparedStatement(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.wrapCallableStatement(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.wrapPreparedStatement(this.delegate.prepareStatement(sql, autoGeneratedKeys));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.wrapPreparedStatement(this.delegate.prepareStatement(sql, columnIndexes));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.wrapPreparedStatement(this.delegate.prepareStatement(sql, columnNames));
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.delegate.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.delegate.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.delegate.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.delegate.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.delegate.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.delegate.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.delegate.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.delegate.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.delegate.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.delegate.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.delegate.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.delegate.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.delegate.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.delegate.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.delegate.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.delegate.getNetworkTimeout();
        }

        @Override
        public void beginRequest() throws SQLException {
            this.delegate.beginRequest();
        }

        @Override
        public void endRequest() throws SQLException {
            this.delegate.endRequest();
        }

        @Override
        public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException {
            return this.delegate.setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
        }

        @Override
        public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException {
            return this.delegate.setShardingKeyIfValid(shardingKey, timeout);
        }

        @Override
        public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException {
            this.delegate.setShardingKey(shardingKey, superShardingKey);
        }

        @Override
        public void setShardingKey(ShardingKey shardingKey) throws SQLException {
            this.delegate.setShardingKey(shardingKey);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }

    public static class XAResourceWrapper
    implements XAResource {
        private final JtaAwareConnectionProviderImpl pool;
        private final ConnectionWrapper connection;
        private int transactionTimeout;

        public XAResourceWrapper(JtaAwareConnectionProviderImpl pool, ConnectionWrapper connection) {
            this.pool = pool;
            this.connection = connection;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            throw new RuntimeException("this should never be called");
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (!onePhase) {
                throw new IllegalArgumentException("must be one phase");
            }
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new XAException(e.toString());
            }
            finally {
                try {
                    this.pool.delist(this.connection);
                }
                catch (Exception exception) {}
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void rollback(Xid xid) throws XAException {
            try {
                Statement runningStatement = this.connection.getRunningStatement();
                if (runningStatement == null) return;
                try {
                    runningStatement.cancel();
                    return;
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    // empty catch block
                    return;
                }
            }
            catch (SQLException e) {
                throw new XAException(e.toString());
            }
            finally {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    try {
                        throw new XAException(e.toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            this.pool.delist(this.connection);
                            throw throwable;
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    this.pool.delist(this.connection);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
        }

        @Override
        public void forget(Xid xid) throws XAException {
        }

        @Override
        public int getTransactionTimeout() {
            return this.transactionTimeout;
        }

        @Override
        public boolean setTransactionTimeout(int i) {
            this.transactionTimeout = i;
            return true;
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            return xaResource == this;
        }

        @Override
        public Xid[] recover(int i) {
            return new Xid[0];
        }
    }
}

