/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PageCursorProvider;
import org.hornetq.core.paging.impl.Page;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.RouteContextList;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.Transaction;

public interface PagingStore
extends HornetQComponent {
    public SimpleString getAddress();

    public int getNumberOfPages();

    public int getCurrentWritingPage();

    public SimpleString getStoreName();

    public String getFolder();

    public AddressFullMessagePolicy getAddressFullMessagePolicy();

    public long getFirstPage();

    public long getTopPage();

    public long getPageSizeBytes();

    public long getAddressSize();

    public long getMaxSize();

    public void applySetting(AddressSettings var1);

    public boolean isPaging();

    public void sync() throws Exception;

    public void ioSync() throws Exception;

    public boolean page(ServerMessage var1, Transaction var2, RouteContextList var3, ReentrantReadWriteLock.ReadLock var4) throws Exception;

    public Page createPage(int var1) throws Exception;

    public boolean checkPageFileExists(int var1) throws Exception;

    public PagingManager getPagingManager();

    public PageCursorProvider getCursorProvider();

    public void processReload() throws Exception;

    public Page depage() throws Exception;

    public void forceAnotherPage() throws Exception;

    public Page getCurrentPage();

    public boolean startPaging() throws Exception;

    public void stopPaging() throws Exception;

    public void addSize(int var1);

    public boolean checkMemory(Runnable var1);

    public boolean lock(long var1);

    public void unlock();

    public void flushExecutors();

    public Collection<Integer> getCurrentIds() throws Exception;

    public void sendPages(ReplicationManager var1, Collection<Integer> var2) throws Exception;
}

