/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationAddMessage
extends PacketImpl {
    private long id;
    private byte journalID;
    private boolean isUpdate;
    private byte recordType;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationAddMessage() {
        super((byte)91);
    }

    public ReplicationAddMessage(byte journalID, boolean isUpdate, long id, byte recordType, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.isUpdate = isUpdate;
        this.id = id;
        this.recordType = recordType;
        this.encodingData = encodingData;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.isUpdate);
        buffer.writeLong(this.id);
        buffer.writeByte(this.recordType);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.isUpdate = buffer.readBoolean();
        this.id = buffer.readLong();
        this.recordType = buffer.readByte();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encodingData == null ? 0 : this.encodingData.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isUpdate ? 1231 : 1237);
        result = 31 * result + this.journalID;
        result = 31 * result + Arrays.hashCode(this.recordData);
        result = 31 * result + this.recordType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationAddMessage)) {
            return false;
        }
        ReplicationAddMessage other = (ReplicationAddMessage)((Object)obj);
        if (this.encodingData == null ? other.encodingData != null : !this.encodingData.equals(other.encodingData)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isUpdate != other.isUpdate) {
            return false;
        }
        if (this.journalID != other.journalID) {
            return false;
        }
        if (!Arrays.equals(this.recordData, other.recordData)) {
            return false;
        }
        return this.recordType == other.recordType;
    }
}

