/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.VersionedStompFrameHandler;

public class HornetQStompException
extends Exception {
    private static final long serialVersionUID = -274452327574950068L;
    private final List<Header> headers = new ArrayList<Header>(10);
    private String body;
    private VersionedStompFrameHandler handler;
    private boolean disconnect;

    public HornetQStompException(StompConnection connection, String msg) {
        super(msg);
        this.handler = connection.getFrameHandler();
    }

    public HornetQStompException(String msg) {
        super(msg);
    }

    public HornetQStompException(String msg, Throwable t) {
        super(msg, t);
        this.body = t.getMessage();
    }

    public HornetQStompException(Throwable t) {
        super(t);
    }

    public void addHeader(String header, String value) {
        this.headers.add(new Header(header, value));
    }

    public void setBody(String body) {
        this.body = body;
    }

    public StompFrame getFrame() {
        StompFrame frame = null;
        frame = this.handler == null ? new StompFrame("ERROR") : this.handler.createStompFrame("ERROR");
        frame.addHeader("message", this.getMessage());
        for (Header header : this.headers) {
            frame.addHeader(header.key, header.val);
        }
        if (this.body != null) {
            try {
                frame.setByteBody(this.body.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            frame.setByteBody(new byte[0]);
        }
        frame.setNeedsDisconnect(this.disconnect);
        return frame;
    }

    public void setDisconnect(boolean b) {
        this.disconnect = b;
    }

    private static final class Header {
        public final String key;
        public final String val;

        public Header(String key, String val) {
            this.key = key;
            this.val = val;
        }
    }
}

