/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.spi.core.security.HornetQSecurityManagerImpl;

public class HornetQServers {
    public static HornetQServer newHornetQServer(Configuration config, boolean enablePersistence) {
        HornetQSecurityManagerImpl securityManager = new HornetQSecurityManagerImpl();
        HornetQServer server = HornetQServers.newHornetQServer(config, ManagementFactory.getPlatformMBeanServer(), securityManager, enablePersistence);
        return server;
    }

    public static HornetQServer newHornetQServer(Configuration config) {
        return HornetQServers.newHornetQServer(config, config.isPersistenceEnabled());
    }

    public static HornetQServer newHornetQServer(Configuration config, MBeanServer mbeanServer, boolean enablePersistence) {
        HornetQSecurityManagerImpl securityManager = new HornetQSecurityManagerImpl();
        HornetQServer server = HornetQServers.newHornetQServer(config, mbeanServer, securityManager, enablePersistence);
        return server;
    }

    public static HornetQServer newHornetQServer(Configuration config, MBeanServer mbeanServer) {
        return HornetQServers.newHornetQServer(config, mbeanServer, true);
    }

    public static HornetQServer newHornetQServer(Configuration config, MBeanServer mbeanServer, HornetQSecurityManager securityManager) {
        HornetQServer server = HornetQServers.newHornetQServer(config, mbeanServer, securityManager, true);
        return server;
    }

    public static HornetQServer newHornetQServer(Configuration config, MBeanServer mbeanServer, HornetQSecurityManager securityManager, boolean enablePersistence) {
        config.setPersistenceEnabled(enablePersistence);
        HornetQServerImpl server = new HornetQServerImpl(config, mbeanServer, securityManager);
        return server;
    }

    public static HornetQServer newHornetQServer(Configuration config, String defUser, String defPass) {
        HornetQSecurityManagerImpl securityManager = new HornetQSecurityManagerImpl();
        securityManager.addUser(defUser, defPass);
        HornetQServer server = HornetQServers.newHornetQServer(config, ManagementFactory.getPlatformMBeanServer(), securityManager, config.isPersistenceEnabled());
        return server;
    }

    public static HornetQServer newHornetQServer(Configuration config, MBeanServer mbeanServer, boolean enablePersistence, String user, String password) {
        HornetQSecurityManagerImpl securityManager = new HornetQSecurityManagerImpl();
        securityManager.addUser(user, password);
        HornetQServer server = HornetQServers.newHornetQServer(config, mbeanServer, securityManager, enablePersistence);
        return server;
    }
}

